/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.verificationcode;

import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeValidator;
import com.verisign.epp.codec.verificationcode.TrustAnchorVerificationData;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.TrustAnchor;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class TrustAnchorVerificationCodeValidator
implements EPPVerificationCodeValidator {
    private static Logger cat = Logger.getLogger((String)TrustAnchorVerificationCodeValidator.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private KeyStore trustStore;

    public TrustAnchorVerificationCodeValidator(KeyStore aTrustStore) {
        this.trustStore = aTrustStore;
    }

    @Override
    public boolean validate(EPPVerificationCode aVerificationCode, Object aData) throws EPPException {
        cat.debug((Object)"validate(EPPVerificationCode, Object): enter");
        boolean theRet = false;
        if (aData == null) {
            throw new EPPException("TrustAnchorVerificationCodeValidator.validate: aData is null");
        }
        if (!(aData instanceof TrustAnchor)) {
            throw new EPPException("TrustAnchorVerificationCodeValidator.validate: aData is null");
        }
        TrustAnchor theTrustAnchor = (TrustAnchor)aData;
        String theTrustAnchorAlias = "";
        try {
            theTrustAnchorAlias = this.trustStore.getCertificateAlias(theTrustAnchor.getTrustedCert());
            cat.debug((Object)("TrustAnchorVerificationCodeValidator.validate:theTrustAnchorAlias = " + theTrustAnchorAlias));
            TrustAnchorVerificationData trustAnchorData = new TrustAnchorVerificationData(theTrustAnchorAlias);
            if (aVerificationCode.getVspId() != trustAnchorData.getCodeVspId()) {
                cat.debug((Object)("TrustAnchorVerificationCodeValidator.validate:verification code vspId " + aVerificationCode.getVspId() + " != trust anchor code vspId " + trustAnchorData.getCodeVspId()));
                return false;
            }
            if (!trustAnchorData.getCodeTypes().contains(aVerificationCode.getType())) {
                cat.debug((Object)("TrustAnchorVerificationCodeValidator.validate:verification code type " + aVerificationCode.getType() + " not contained in trust anchor types"));
                return false;
            }
            cat.debug((Object)("TrustAnchorVerificationCodeValidator.validate:Code is valid with theTrustAnchorAlias = " + theTrustAnchorAlias));
            theRet = true;
        }
        catch (KeyStoreException e) {
            throw new EPPException("TrustAnchorVerificationCodeValidator.validate:Error getting Trust Anchor Alias: " + e);
        }
        cat.debug((Object)"validate(EPPVerificationCode, Object): exit");
        return theRet;
    }
}

