/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPValidateKeyValue
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPValidateKeyValue.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "kv";
    public static final String ELM_NAME = "validate:kv";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_CONTACT_TYPE = "contactType";
    private String key;
    private String value;
    private String contactType;

    public EPPValidateKeyValue() {
    }

    public EPPValidateKeyValue(String aKey, String aValue) {
        this.key = aKey;
        this.value = aValue;
    }

    public EPPValidateKeyValue(String aKey, String aValue, String aContactType) {
        this.key = aKey;
        this.value = aValue;
        this.contactType = aContactType;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String aValue) {
        this.value = aValue;
    }

    public boolean hasContactType() {
        return this.contactType != null;
    }

    public String getContactType() {
        return this.contactType;
    }

    public void setContactType(String aType) {
        this.contactType = aType;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.key == null) {
            throw new EPPEncodeException("Undefined key in EPPValidateKeyValue");
        }
        if (this.value == null) {
            throw new EPPEncodeException("Undefined value in EPPValidateKeyValue");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        root.setAttribute(ATTR_KEY, this.key);
        root.setAttribute(ATTR_VALUE, this.value);
        if (this.hasContactType()) {
            root.setAttribute(ATTR_CONTACT_TYPE, this.contactType);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.key = EPPUtil.decodeStringAttr(aElement, ATTR_KEY);
        this.value = EPPUtil.decodeStringAttr(aElement, ATTR_VALUE);
        this.contactType = EPPUtil.decodeStringAttr(aElement, ATTR_CONTACT_TYPE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateKeyValue)) {
            return false;
        }
        EPPValidateKeyValue other = (EPPValidateKeyValue)aObject;
        if (!EqualityUtil.equals(this.key, other.key)) {
            cat.error((Object)"EPPValidateKeyValue.equals(): key not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.value, other.value)) {
            cat.error((Object)"EPPValidateKeyValue.equals(): value not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contactType, other.contactType)) {
            cat.error((Object)"EPPValidateKeyValue.equals(): contactType not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateKeyValue clone = null;
        clone = (EPPValidateKeyValue)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }
}

