/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.validate.v02.EPPValidateAuthInfo;
import com.verisign.epp.codec.validate.v02.EPPValidateKeyValue;
import com.verisign.epp.codec.validate.v02.EPPValidatePostalDefinition;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPValidateContact
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPValidateContact.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "contact";
    public static final String ELM_NAME = "validate:contact";
    private static final String ELM_ID = "id";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ATTR_EXT = "x";
    private static final String ATTR_CONTACT_TYPE = "contactType";
    private static final String ATTR_TLD = "tld";
    private String id;
    private String contactType;
    private String tld;
    private List<EPPValidatePostalDefinition> postalInfo = new ArrayList<EPPValidatePostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private EPPValidateAuthInfo authInfo;
    private List<EPPValidateKeyValue> keyValues = new ArrayList<EPPValidateKeyValue>();

    public EPPValidateContact() {
    }

    public EPPValidateContact(String aId, String aContactType, String aTld) {
        this.id = aId;
        this.contactType = aContactType;
        this.tld = aTld;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public String getContactType() {
        return this.contactType;
    }

    public void setContactType(String aType) {
        this.contactType = aType;
    }

    public String getTld() {
        return this.tld;
    }

    public void setTld(String aTld) {
        this.tld = aTld;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPValidatePostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPValidatePostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPValidatePostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo == null ? new ArrayList<EPPValidatePostalDefinition>() : aPostalInfo;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public boolean hasVoiceExt() {
        return this.voiceExt != null;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public boolean hasFax() {
        return this.fax != null;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public boolean hasFaxExt() {
        return this.faxExt != null;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public boolean hasEmail() {
        return this.email != null;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public boolean hasAuthInfo() {
        return this.authInfo != null;
    }

    public EPPValidateAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPValidateAuthInfo aAuthInfo) {
        this.authInfo = aAuthInfo;
    }

    public void addKeyValue(EPPValidateKeyValue aKeyValue) {
        this.keyValues.add(aKeyValue);
    }

    public void setKeyValues(List<EPPValidateKeyValue> aKeyValues) {
        this.keyValues = aKeyValues == null ? new ArrayList<EPPValidateKeyValue>() : aKeyValues;
    }

    public List<EPPValidateKeyValue> getKeyValues() {
        return this.keyValues;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.id == null) {
            throw new EPPEncodeException("Undefined id in EPPValidateContact");
        }
        if (this.contactType == null) {
            throw new EPPEncodeException("Undefined contactType in EPPValidateContact");
        }
        if (this.tld == null) {
            throw new EPPEncodeException("Undefined tld in EPPValidateContact");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", ELM_NAME);
        root.setAttribute(ATTR_CONTACT_TYPE, this.contactType);
        root.setAttribute(ATTR_TLD, this.tld);
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:validate-0.2", "validate:id");
        EPPUtil.encodeCompList(aDocument, root, this.postalInfo);
        if (this.voice != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", "validate:voice");
            theVal = aDocument.createTextNode(this.voice);
            theElm.appendChild(theVal);
            if (this.voiceExt != null) {
                theElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            root.appendChild(theElm);
        }
        if (this.fax != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:validate-0.2", "validate:fax");
            theVal = aDocument.createTextNode(this.fax);
            theElm.appendChild(theVal);
            if (this.faxExt != null) {
                theElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            root.appendChild(theElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:validate-0.2", "validate:email");
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        EPPUtil.encodeCompList(aDocument, root, this.keyValues);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:validate-0.2", ELM_ID);
        this.contactType = EPPUtil.decodeStringAttr(aElement, ATTR_CONTACT_TYPE);
        this.tld = EPPUtil.decodeStringAttr(aElement, ATTR_TLD);
        this.postalInfo = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:validate-0.2", "validate:postalInfo", EPPValidatePostalDefinition.class);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:validate-0.2", ELM_VOICE);
        if (theElm != null) {
            this.voice = EPPUtil.getTextContent(theElm);
            this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.voice = null;
            this.voiceExt = null;
        }
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:validate-0.2", ELM_FAX);
        if (theElm != null) {
            this.fax = EPPUtil.getTextContent(theElm);
            this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.fax = null;
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:validate-0.2", ELM_EMAIL);
        this.authInfo = (EPPValidateAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:validate-0.2", "validate:authInfo", EPPValidateAuthInfo.class);
        this.keyValues = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:validate-0.2", "validate:kv", EPPValidateKeyValue.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPValidateContact clone = (EPPValidateContact)super.clone();
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPValidateAuthInfo)this.authInfo.clone();
        }
        clone.keyValues = new ArrayList<EPPValidateKeyValue>(this.keyValues.size());
        for (EPPValidateKeyValue item : this.keyValues) {
            clone.keyValues.add((EPPValidateKeyValue)item.clone());
        }
        return clone;
    }

    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPValidateContact)) {
            return false;
        }
        EPPValidateContact other = (EPPValidateContact)aObject;
        if (!EqualityUtil.equals(this.id, other.id)) {
            cat.error((Object)"EPPValidateContact.equals(): id not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contactType, other.contactType)) {
            cat.error((Object)"EPPValidateContact.equals(): contactType not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.tld, other.tld)) {
            cat.error((Object)"EPPValidateContact.equals(): tld not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPValidateContact.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPValidateContact.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPValidateContact.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error((Object)"EPPValidateContact.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error((Object)("EPPValidateContact.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt));
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPValidateContact.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.authInfo, other.authInfo)) {
            cat.error((Object)"EPPValidateContact.equals(): authInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.keyValues, other.keyValues)) {
            cat.error((Object)"EPPValidateContact.equals(): keyValues not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

