/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v02.EPPRegistryCheckResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCheckResp
extends EPPResponse {
    private static Logger cat = Logger.getLogger(EPPRegistryCheckResp.class);
    public static final String ELM_LOCALNAME = "chkData";
    public static final String ELM_NAME = "registry:chkData";
    private List<EPPRegistryCheckResult> checkResults = new ArrayList<EPPRegistryCheckResult>();

    public EPPRegistryCheckResp() {
    }

    public EPPRegistryCheckResp(EPPTransId aTransId, EPPRegistryCheckResult aResult) {
        super(aTransId);
        this.checkResults.add(aResult);
    }

    public EPPRegistryCheckResp(EPPTransId aTransId, List aResults) {
        super(aTransId);
        this.setCheckResults(aResults);
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.checkResults == null || this.checkResults.size() == 0) {
            throw new EPPEncodeException("Invalid state on EPPRegistryInfoResp.encode: chekResults is empty");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.2", ELM_NAME);
        EPPUtil.encodeCompList(aDocument, root, this.checkResults);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.checkResults = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:registry-0.2", "registry:cd", EPPRegistryCheckResult.class);
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.2";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCheckResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryCheckResp theCheckData = (EPPRegistryCheckResp)aObject;
        if (!EPPUtil.equalLists(this.checkResults, theCheckData.checkResults)) {
            cat.error((Object)"EPPRegistryCheckResp: checkResults not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCheckResp clone = (EPPRegistryCheckResp)super.clone();
        clone.checkResults = (List)((ArrayList)this.checkResults).clone();
        for (int i = 0; i < this.checkResults.size(); ++i) {
            if (this.checkResults.get(i) == null) {
                clone.checkResults.set(i, null);
                continue;
            }
            clone.checkResults.set(i, (EPPRegistryCheckResult)this.checkResults.get(i).clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public List<EPPRegistryCheckResult> getCheckResults() {
        return this.checkResults;
    }

    public void setCheckResults(List<EPPRegistryCheckResult> aResults) {
        this.checkResults = aResults == null ? new ArrayList<EPPRegistryCheckResult>() : aResults;
    }
}

