/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.policy.EPPRegistryZoneInterface;
import com.verisign.epp.codec.registry.v01.EPPRegistryBatchJob;
import com.verisign.epp.codec.registry.v01.EPPRegistryContact;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomain;
import com.verisign.epp.codec.registry.v01.EPPRegistryHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryServices;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneName;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryZone
implements EPPCodecComponent,
EPPRegistryZoneInterface {
    private static Logger cat = Logger.getLogger((String)EPPRegistryZone.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "zone";
    public static final String ELM_NAME = "registry:zone";
    private static final String ELM_GROUP = "group";
    private static final String ELM_CRDATE = "crDate";
    private static final String ELM_CRID = "crID";
    private static final String ELM_UPDATE = "upDate";
    private static final String ELM_UPID = "upID";
    private static final String ELM_BATCH = "batch";
    private static final String ELM_SYSTEM = "system";
    private EPPRegistryZoneName name = null;
    private String group = null;
    private EPPRegistryServices services = null;
    private String createdBy = null;
    private Date createdDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private List<EPPRegistryBatchJob> batchJobs = new ArrayList<EPPRegistryBatchJob>();
    private List<EPPRegistryZoneName> systemZones = new ArrayList<EPPRegistryZoneName>();
    private EPPRegistryDomain domain = null;
    private EPPRegistryHost host = null;
    private EPPRegistryContact contact = null;

    public EPPRegistryZone() {
    }

    public EPPRegistryZone(String aName) {
        this.setName(aName);
    }

    public EPPRegistryZone(EPPRegistryZoneName aName) {
        this.setName(aName);
    }

    public EPPRegistryZone(String aName, String aCreatedBy, Date aCreatedDate) {
        this(aName);
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
    }

    public EPPRegistryZone(EPPRegistryZoneName aName, String aCreatedBy, Date aCreatedDate) {
        this(aName);
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPRegistryZone.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("Invalid state on EPPRegistryZone.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.name);
        EPPUtil.encodeString(aDocument, root, this.group, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:group");
        EPPUtil.encodeComp(aDocument, root, this.services);
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:crID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:crDate");
        EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:upID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:upDate");
        if (this.hasBatchJobs()) {
            Element theBatchElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:batch");
            root.appendChild(theBatchElm);
            EPPUtil.encodeCompList(aDocument, theBatchElm, this.batchJobs);
        }
        if (this.hasSystemZones()) {
            Element theSystemElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", "registry:system");
            root.appendChild(theSystemElm);
            EPPUtil.encodeCompList(aDocument, theSystemElm, this.systemZones);
        }
        EPPUtil.encodeComp(aDocument, root, this.domain);
        EPPUtil.encodeComp(aDocument, root, this.host);
        EPPUtil.encodeComp(aDocument, root, this.contact);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = (EPPRegistryZoneName)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "name", EPPRegistryZoneName.class);
        this.group = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_GROUP);
        this.services = (EPPRegistryServices)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:services", EPPRegistryServices.class);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_CRID);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_CRDATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_UPID);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_UPDATE);
        Element theBatchElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_BATCH);
        this.batchJobs = theBatchElm != null ? EPPUtil.decodeCompList(theBatchElm, "urn:ietf:params:xml:ns:epp:registry-0.1", "batchJob", EPPRegistryBatchJob.class) : new ArrayList<EPPRegistryBatchJob>();
        Element theSystemZoneElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_SYSTEM);
        this.systemZones = theSystemZoneElm != null ? EPPUtil.decodeCompList(theSystemZoneElm, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_LOCALNAME, EPPRegistryZoneName.class) : new ArrayList<EPPRegistryZoneName>();
        this.domain = (EPPRegistryDomain)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:domain", EPPRegistryDomain.class);
        this.host = (EPPRegistryHost)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:host", EPPRegistryHost.class);
        this.contact = (EPPRegistryContact)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:contact", EPPRegistryContact.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryZone)) {
            return false;
        }
        EPPRegistryZone theComp = (EPPRegistryZone)aObject;
        if (!EqualityUtil.equals(this.name, theComp.name)) {
            cat.error((Object)"EPPRegistryZone.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.group, theComp.group)) {
            cat.error((Object)"EPPRegistryZone.equals(): group not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdBy, theComp.createdBy)) {
            cat.error((Object)"EPPRegistryZone.equals(): createdBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.createdDate, theComp.createdDate)) {
            cat.error((Object)"EPPRegistryZone.equals(): createdDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedBy, theComp.lastUpdatedBy)) {
            cat.error((Object)"EPPRegistryZone.equals(): lastUpdatedBy not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lastUpdatedDate, theComp.lastUpdatedDate)) {
            cat.error((Object)"EPPRegistryZone.equals(): lastUpdatedDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.batchJobs, theComp.batchJobs)) {
            cat.error((Object)"EPPRegistryZone.equals(): batchJobs not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.systemZones, theComp.systemZones)) {
            cat.error((Object)"EPPRegistryZone.equals(): systemZones not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.services, theComp.services)) {
            cat.error((Object)"EPPRegistryZone.equals(): services not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.domain, theComp.domain)) {
            cat.error((Object)"EPPRegistryZone.equals(): domain not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.host, theComp.host)) {
            cat.error((Object)"EPPRegistryZone.equals(): host not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contact, theComp.contact)) {
            cat.error((Object)"EPPRegistryZone.equals(): contact not equal");
            return false;
        }
        return true;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required element is not set");
        }
        if (this.domain == null) {
            throw new EPPCodecException("domain required element is not set");
        }
        if (this.host == null) {
            throw new EPPCodecException("host required element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryZone clone = (EPPRegistryZone)super.clone();
        if (this.batchJobs != null) {
            clone.batchJobs = (List)((ArrayList)this.batchJobs).clone();
        }
        if (this.systemZones != null) {
            clone.systemZones = (List)((ArrayList)this.systemZones).clone();
        }
        if (this.services != null) {
            clone.services = (EPPRegistryServices)this.services.clone();
        }
        if (this.domain != null) {
            clone.domain = (EPPRegistryDomain)this.domain.clone();
        }
        if (this.host != null) {
            clone.host = (EPPRegistryHost)this.host.clone();
        }
        if (this.contact != null) {
            clone.contact = (EPPRegistryContact)this.contact.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public EPPRegistryZoneName getName() {
        return this.name;
    }

    public void setName(EPPRegistryZoneName aName) {
        this.name = aName;
    }

    public void setName(String aName) {
        this.name = aName == null ? null : new EPPRegistryZoneName(aName, EPPRegistryZoneName.Form.aLabel);
    }

    public boolean hasServices() {
        return this.services != null;
    }

    public EPPRegistryServices getServices() {
        return this.services;
    }

    public void setServices(EPPRegistryServices services) {
        this.services = services;
    }

    public boolean hasCreatedBy() {
        return this.createdBy != null;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public boolean hasCreatedDate() {
        return this.createdDate != null;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public boolean hasLastUpdatedBy() {
        return this.lastUpdatedBy != null;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public boolean hasLastUpdatedDate() {
        return this.lastUpdatedDate != null;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public boolean hasBatchJobs() {
        return this.batchJobs != null && !this.batchJobs.isEmpty();
    }

    public List<EPPRegistryBatchJob> getBatchJobs() {
        return this.batchJobs;
    }

    public void setBatchJobs(List<EPPRegistryBatchJob> aBatchJobs) {
        this.batchJobs = aBatchJobs == null ? new ArrayList<EPPRegistryBatchJob>() : aBatchJobs;
    }

    public void addBatchJob(EPPRegistryBatchJob aBatchJob) {
        if (aBatchJob == null) {
            return;
        }
        if (this.batchJobs == null) {
            this.batchJobs = new ArrayList<EPPRegistryBatchJob>();
        }
        this.batchJobs.add(aBatchJob);
    }

    public boolean hasSystemZones() {
        return this.systemZones != null && !this.systemZones.isEmpty();
    }

    public List<EPPRegistryZoneName> getSystemZones() {
        return this.systemZones;
    }

    public void setSystemZones(List<EPPRegistryZoneName> aSystemZones) {
        if (aSystemZones == null) {
            this.systemZones = new ArrayList<EPPRegistryZoneName>();
        } else {
            this.systemZones = aSystemZones;
            for (EPPRegistryZoneName theZone : this.systemZones) {
                theZone.setRootName(ELM_LOCALNAME);
            }
        }
    }

    public void addSystemZone(EPPRegistryZoneName aSystemZone) {
        if (aSystemZone == null) {
            return;
        }
        if (this.systemZones == null) {
            this.systemZones = new ArrayList<EPPRegistryZoneName>();
        }
        aSystemZone.setRootName(ELM_LOCALNAME);
        this.systemZones.add(aSystemZone);
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public EPPRegistryDomain getDomain() {
        return this.domain;
    }

    public void setDomain(EPPRegistryDomain domain) {
        this.domain = domain;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public EPPRegistryHost getHost() {
        return this.host;
    }

    public void setHost(EPPRegistryHost host) {
        this.host = host;
    }

    public boolean hasContact() {
        return this.contact != null;
    }

    public EPPRegistryContact getContact() {
        return this.contact;
    }

    public void setContact(EPPRegistryContact contact) {
        this.contact = contact;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String aGroup) {
        this.group = aGroup;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

