/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.registry.v01.EPPRegistryBatchJob;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryCheckResult;
import com.verisign.epp.codec.registry.v01.EPPRegistryContact;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactAddress;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactName;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactOrg;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.v01.EPPRegistryContactStreet;
import com.verisign.epp.codec.registry.v01.EPPRegistryCreateCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryCreateResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryDNSSEC;
import com.verisign.epp.codec.registry.v01.EPPRegistryDS;
import com.verisign.epp.codec.registry.v01.EPPRegistryDeleteCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomain;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainContact;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainHostLimit;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainNSLimit;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainName;
import com.verisign.epp.codec.registry.v01.EPPRegistryDomainPeriod;
import com.verisign.epp.codec.registry.v01.EPPRegistryExternalHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryGracePeriod;
import com.verisign.epp.codec.registry.v01.EPPRegistryHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryIDN;
import com.verisign.epp.codec.registry.v01.EPPRegistryInfoCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryInfoResp;
import com.verisign.epp.codec.registry.v01.EPPRegistryInternalHost;
import com.verisign.epp.codec.registry.v01.EPPRegistryLanguage;
import com.verisign.epp.codec.registry.v01.EPPRegistryMaxSig;
import com.verisign.epp.codec.registry.v01.EPPRegistryMinMaxLength;
import com.verisign.epp.codec.registry.v01.EPPRegistryPendingDeletePeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryPendingRestorePeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryPeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryPostal;
import com.verisign.epp.codec.registry.v01.EPPRegistryRGP;
import com.verisign.epp.codec.registry.v01.EPPRegistryRedemptionPeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryRegex;
import com.verisign.epp.codec.registry.v01.EPPRegistryReservedNames;
import com.verisign.epp.codec.registry.v01.EPPRegistryServices;
import com.verisign.epp.codec.registry.v01.EPPRegistryServicesExt;
import com.verisign.epp.codec.registry.v01.EPPRegistrySupportedStatus;
import com.verisign.epp.codec.registry.v01.EPPRegistrySystemInfo;
import com.verisign.epp.codec.registry.v01.EPPRegistryTransferHoldPeriodType;
import com.verisign.epp.codec.registry.v01.EPPRegistryUpdateCmd;
import com.verisign.epp.codec.registry.v01.EPPRegistryZone;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneList;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneName;
import com.verisign.epp.codec.registry.v01.EPPRegistryZoneSummary;
import com.verisign.epp.util.TestThread;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPRegistryTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPRegistryTst(String name) {
        super(name);
    }

    public void testRegistryInfoZoneList() {
        EPPCodecTst.printStart("testRegistryInfoZoneList");
        EPPRegistryInfoCmd theCommand = new EPPRegistryInfoCmd("ABC-12349", true);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPRegistryZoneList zoneList = new EPPRegistryZoneList();
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54322-XYZ");
        EPPRegistryInfoResp theResponse = new EPPRegistryInfoResp(respTransId, zoneList);
        zoneList.addZone(new EPPRegistryZoneSummary("EXAMPLE1", new GregorianCalendar(2012, 10, 1).getTime(), new GregorianCalendar(2012, 10, 15).getTime()));
        zoneList.addZone(new EPPRegistryZoneSummary("EXAMPLE2", new GregorianCalendar(2012, 9, 1).getTime(), new GregorianCalendar(2012, 9, 19).getTime()));
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPRegistryInfoCmd("ABC-12349", "com");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryZone zoneInfo = EPPRegistryTst.createZoneInfo();
        theResponse = new EPPRegistryInfoResp(respTransId, zoneInfo);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        zoneInfo.setContact(null);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryInfoZoneList");
    }

    public void testRegistryInfoZoneInfo() {
        EPPCodecTst.printStart("testRegistryInfoZoneInfo");
        EPPRegistryInfoCmd theCommand = new EPPRegistryInfoCmd("ABC-12345", "zone1");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPRegistryZone zoneInfo = EPPRegistryTst.createZoneInfo();
        EPPRegistryInfoResp theResponse = new EPPRegistryInfoResp(theTransId, zoneInfo);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        zoneInfo.setContact(null);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryInfoZoneInfo");
    }

    public void testRegistryInfoSystemInfo() {
        EPPCodecTst.printStart("testRegistryInfoSystemInfo");
        EPPRegistryInfoCmd theCommand = new EPPRegistryInfoCmd();
        theCommand.setTransId("ABC-12345");
        theCommand.setSystem(true);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54322-XYZ");
        EPPRegistrySystemInfo theSystemInfo = new EPPRegistrySystemInfo(200, 600000, 86400000, 10000, 10, 1000);
        EPPRegistryInfoResp theResponse = new EPPRegistryInfoResp(theTransId, theSystemInfo);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryInfoSystemInfo");
    }

    public void testRegistryCheck() {
        EPPCodecTst.printStart("testRegistryCheck");
        EPPRegistryCheckCmd theCommand = new EPPRegistryCheckCmd("ABC-12345", "com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPRegistryCheckCmd("ABC-12345", "com");
        theCommand.addName("weirdname");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryCheckResult result = new EPPRegistryCheckResult("com", Boolean.FALSE);
        result.setReason("Already taken");
        EPPRegistryCheckResp theResponse = new EPPRegistryCheckResp(respTransId, result);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        ArrayList<EPPRegistryCheckResult> results = new ArrayList<EPPRegistryCheckResult>();
        result = new EPPRegistryCheckResult("com", Boolean.FALSE);
        result.setReason("Already taken");
        results.add(result);
        results.add(new EPPRegistryCheckResult("availtld", Boolean.FALSE));
        theResponse = new EPPRegistryCheckResp(respTransId, results);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryCheck");
    }

    public void testRegistryCreate() {
        EPPCodecTst.printStart("testRegistryCreate");
        EPPRegistryZone zone = EPPRegistryTst.createZoneInfo();
        zone.setName("newtld");
        EPPRegistryCreateCmd theCommand = null;
        theCommand = new EPPRegistryCreateCmd("ABC-12349", zone);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPRegistryCreateResp theResponse = new EPPRegistryCreateResp(respTransId, "newtld");
        Calendar baseCal = Calendar.getInstance();
        Calendar endCal = (Calendar)baseCal.clone();
        theResponse.setCreateDate(baseCal.getTime());
        endCal = (Calendar)baseCal.clone();
        endCal.add(2, 9);
        endCal.add(1, 10);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryCreate");
    }

    public void testRegistryUpdate() {
        EPPCodecTst.printStart("testRegistryUpdate");
        EPPRegistryZone zone = new EPPRegistryZone();
        zone.setName("newtld");
        EPPRegistryUpdateCmd theCommand = null;
        theCommand = new EPPRegistryUpdateCmd("ABC-12349", zone);
        zone.setDomain(this.buildInfoDomain());
        zone.setHost(this.buildInfoHost());
        zone.setContact(this.buildContact());
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:epp:registry-0.1", Boolean.TRUE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:epp:registry-0.1", Boolean.TRUE));
        zone.setServices(services);
        zone.setCreatedBy("crId");
        zone.setCreatedDate(new Date());
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryUpdate");
    }

    public void testRegistryDelete() {
        EPPCodecTst.printStart("testRegistryDelete");
        EPPRegistryDeleteCmd theCommand = null;
        theCommand = new EPPRegistryDeleteCmd("ABC-12349", "newetld");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testRegistryDelete");
    }

    public static EPPRegistryZone createZoneInfo() {
        EPPRegistryZone zoneInfo = new EPPRegistryZone("com");
        zoneInfo.setGroup("1");
        EPPRegistryServices services = new EPPRegistryServices();
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/rgp-poll-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:host-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:contact-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("urn:ietf:params:xml:ns:domain-1.0", Boolean.TRUE));
        services.addObjURI(new EPPRegistryServices.EPPRegistryObjURI("http://www.verisign.com/epp/lowbalance-poll-1.0", Boolean.FALSE));
        EPPRegistryServicesExt svcExt = new EPPRegistryServicesExt();
        services.setExtension(svcExt);
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign-grs.com/epp/namestoreExt-1.1", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:rgp-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/sync-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/idnLang-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/jobsContact-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("http://www.verisign.com/epp/premiumdomain-1.0", Boolean.TRUE));
        svcExt.addExtURI(new EPPRegistryServicesExt.EPPRegistryExtURI("urn:ietf:params:xml:ns:secDNS-1.1", Boolean.FALSE));
        zoneInfo.setServices(services);
        zoneInfo.setCreatedBy("crId");
        zoneInfo.setCreatedDate(new Date());
        zoneInfo.setLastUpdatedBy("upId");
        zoneInfo.setLastUpdatedDate(new Date());
        zoneInfo.addBatchJob(new EPPRegistryBatchJob("pendingDelete", "0 14 * * *", "Pending Delete Batch", "EDT5EDT"));
        zoneInfo.addSystemZone(new EPPRegistryZoneName("EXAMPLE"));
        zoneInfo.addSystemZone(new EPPRegistryZoneName("EXAMPLE2", EPPRegistryZoneName.Form.aLabel));
        zoneInfo.setDomain(EPPRegistryTst.buildInfoDomain());
        zoneInfo.setHost(EPPRegistryTst.buildInfoHost());
        zoneInfo.setContact(EPPRegistryTst.buildContact());
        return zoneInfo;
    }

    public static EPPRegistrySystemInfo createSystemInfo() {
        return new EPPRegistrySystemInfo(200, 600000, 86400000, 10000, 10, 1000);
    }

    public static EPPRegistryDomain buildInfoDomain() {
        EPPRegistryDomain domain = new EPPRegistryDomain();
        ArrayList<EPPRegistryDomainName> domainNames = new ArrayList<EPPRegistryDomainName>();
        EPPRegistryDomainName domainName = new EPPRegistryDomainName();
        domainName.setLevel(2);
        domainName.setMinLength(5);
        domainName.setMaxLength(50);
        domainName.setAlphaNumStart(true);
        domainName.setAlphaNumEnd(false);
        domainName.setALabelSupported(true);
        ArrayList<EPPRegistryRegex> regex = new ArrayList<EPPRegistryRegex>();
        EPPRegistryRegex r = new EPPRegistryRegex("^\\w+.*$", "test regex");
        regex.add(r);
        r = new EPPRegistryRegex("^\\d+.*$");
        regex.add(r);
        domainName.setRegex(regex);
        EPPRegistryReservedNames reservedNames = new EPPRegistryReservedNames();
        ArrayList<String> rNames = new ArrayList<String>();
        reservedNames.setReservedNames(rNames);
        rNames.add("reserved1");
        rNames.add("reserved2");
        domainName.setReservedNames(reservedNames);
        domainNames.add(domainName);
        try {
            domainName = (EPPRegistryDomainName)domainName.clone();
            domainName.setLevel(3);
            domainName.getReservedNames().setReservedNames(new ArrayList<String>());
            domainName.getReservedNames().setReservedNameURI("http://testrn.vrsn.com");
            domainNames.add(domainName);
        }
        catch (CloneNotSupportedException e) {
            EPPRegistryTst.fail((String)"failed to clone domainName");
        }
        domain.setDomainNames(domainNames);
        EPPRegistryIDN idn = new EPPRegistryIDN();
        idn.setIdnVersion("1.1");
        idn.setIdnaVersion("2008");
        idn.setUnicodeVersion("6.0");
        idn.addLanguage(new EPPRegistryLanguage("CHI", "http://www.iana.org/domains/idn-tables/tables/com_zh_1.1.txt", EPPRegistryLanguage.VariantStrategy.restricted));
        idn.addLanguage(new EPPRegistryLanguage("LATN", "http://www.iana.org/domains/idn-tables/tables/eu_latn_1.0.html", EPPRegistryLanguage.VariantStrategy.blocked));
        idn.setCommingleAllowed(Boolean.TRUE);
        domain.setIdn(idn);
        domain.setPremiumSupport(true);
        domain.setContactsSupported(false);
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.admin, 1, 4));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.billing, 2, 5));
        domain.addContact(new EPPRegistryDomainContact(EPPRegistryDomainContact.Type.tech, 3, 6));
        domain.setNameServerLimit(new EPPRegistryDomainNSLimit(1, 16));
        domain.setChildHostLimit(new EPPRegistryDomainHostLimit(2, 32));
        domain.addPeriod(new EPPRegistryDomainPeriod("create", Boolean.TRUE));
        domain.addPeriod(new EPPRegistryDomainPeriod("renew", 1, EPPRegistryPeriodType.Unit.y, 60, EPPRegistryPeriodType.Unit.m, 5, EPPRegistryPeriodType.Unit.y));
        domain.addPeriod(new EPPRegistryDomainPeriod("transfer", 1, EPPRegistryPeriodType.Unit.y, 8, EPPRegistryPeriodType.Unit.y, 3, EPPRegistryPeriodType.Unit.y));
        domain.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(5, EPPRegistryPeriodType.Unit.d));
        domain.addGracePeriod(new EPPRegistryGracePeriod("create", 1, EPPRegistryPeriodType.Unit.d));
        domain.addGracePeriod(new EPPRegistryGracePeriod("renew", 2, EPPRegistryPeriodType.Unit.h));
        domain.addGracePeriod(new EPPRegistryGracePeriod("transfer", 3, EPPRegistryPeriodType.Unit.m));
        EPPRegistryRGP rgp = new EPPRegistryRGP();
        rgp.setPendingDeletePeriod(new EPPRegistryPendingDeletePeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setRedemptionPeriod(new EPPRegistryRedemptionPeriodType(1, EPPRegistryPeriodType.Unit.m));
        rgp.setPendingRestorePeriod(new EPPRegistryPendingRestorePeriodType(1, EPPRegistryPeriodType.Unit.m));
        domain.setRgp(rgp);
        EPPRegistryDNSSEC dnssec = new EPPRegistryDNSSEC();
        EPPRegistryDS ds = new EPPRegistryDS(1, 3, null, null);
        ds.addAlgorithm("algDS1");
        ds.addAlgorithm("algDS2");
        ds.addDigestType("digest1");
        ds.addDigestType("digest2");
        dnssec.setDs(ds);
        dnssec.setMaxSigLife(new EPPRegistryMaxSig(true, 1, 2, 3));
        dnssec.setUrgent(Boolean.TRUE);
        domain.setDnssec(dnssec);
        domain.setMaxCheckDomain(12);
        domain.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientHold");
        supportedStatus.addStatus("serverHold");
        supportedStatus.addStatus("clientRenewProhibited");
        supportedStatus.addStatus("serverRenewProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("inactive");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingRenew");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        domain.setSupportedStatus(supportedStatus);
        return domain;
    }

    public static EPPRegistryHost buildInfoHost() {
        EPPRegistryHost host = new EPPRegistryHost();
        host.setInternal(new EPPRegistryInternalHost(5, 15, EPPRegistryInternalHost.SharePolicy.perZone, Boolean.FALSE));
        host.setExternal(new EPPRegistryExternalHost(2, 12, EPPRegistryExternalHost.SharePolicy.perZone, Boolean.FALSE));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp1"));
        host.addNameRegex(new EPPRegistryRegex("^.*$", "exp2"));
        host.setMaxCheckHost(15);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        host.setSupportedStatus(supportedStatus);
        return host;
    }

    public static EPPRegistryContact buildContact() {
        EPPRegistryContact contact = new EPPRegistryContact();
        contact.setIntPostalInfoTypeSupport(EPPRegistryContact.PostalInfoTypeSupport.locSupport);
        contact.setContactIdRegex(new EPPRegistryRegex("^.*$"));
        contact.setSharePolicy(EPPRegistryContact.SharePolicy.perZone);
        contact.setAuthInfoRegex(new EPPRegistryRegex("^.*$", "exp"));
        contact.setMaxCheckContact(15);
        EPPRegistryPostal postalInfo = new EPPRegistryPostal();
        postalInfo.setName(new EPPRegistryContactName(5, 15));
        postalInfo.setOrg(new EPPRegistryContactOrg(2, 12));
        postalInfo.setVoiceRequired(Boolean.TRUE);
        postalInfo.setVoiceExt(new EPPRegistryMinMaxLength(5, 15));
        postalInfo.setFaxExt(new EPPRegistryMinMaxLength(5, 15));
        ArrayList emailRegex = new ArrayList();
        postalInfo.setEmailRegex(new EPPRegistryRegex("^.+\\..+$"));
        EPPRegistryContactAddress address = new EPPRegistryContactAddress();
        address.setStreet(new EPPRegistryContactStreet(2, 12, 0, 3));
        address.setCity(new EPPRegistryContactCity(5, 15));
        address.setStateProvince(new EPPRegistryContactStateProvince(1, 11));
        address.setPostalCode(new EPPRegistryContactPostalCode(2, 12));
        postalInfo.setAddress(address);
        contact.setMaxCheckContact(5);
        contact.setPostalInfo(postalInfo);
        contact.setClientDisclosureSupported(Boolean.TRUE);
        EPPRegistrySupportedStatus supportedStatus = new EPPRegistrySupportedStatus();
        supportedStatus.addStatus("clientDeleteProhibited");
        supportedStatus.addStatus("serverDeleteProhibited");
        supportedStatus.addStatus("clientTransferProhibited");
        supportedStatus.addStatus("serverTransferProhibited");
        supportedStatus.addStatus("clientUpdateProhibited");
        supportedStatus.addStatus("serverUpdateProhibited");
        supportedStatus.addStatus("linked");
        supportedStatus.addStatus("ok");
        supportedStatus.addStatus("pendingCreate");
        supportedStatus.addStatus("pendingDelete");
        supportedStatus.addStatus("pendingTransfer");
        supportedStatus.addStatus("pendingUpdate");
        contact.setSupportedStatus(supportedStatus);
        contact.setTransferHoldPeriod(new EPPRegistryTransferHoldPeriodType(5, EPPRegistryPeriodType.Unit.d));
        return contact;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPRegistryTst Thread " + i, EPPRegistryTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPRegistryTst.suite());
        }
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPRegistryTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.registry.v01.EPPRegistryMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPRegistryMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

