/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryLanguage
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryLanguage.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "language";
    public static final String ELM_NAME = "registry:language";
    static final String ELM_TABLE_NAME = "table";
    static final String ELM_VARIANT_STRATEGY_NAME = "variantStrategy";
    static final String ATTR_CODE = "code";
    private String table = null;
    private VariantStrategy variantStrategy = null;
    private String code = null;

    public EPPRegistryLanguage() {
    }

    public EPPRegistryLanguage(String aCode, String aTable, VariantStrategy aVariantStrategy) {
        this.code = aCode;
        this.table = aTable;
        this.variantStrategy = aVariantStrategy;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.code == null || this.code.trim().length() == 0) {
            throw new EPPEncodeException("Invalide state on EPPRegistryLanguage.encode: attribute code is required.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        root.setAttribute(ATTR_CODE, this.code);
        if (this.table != null) {
            EPPUtil.encodeString(aDocument, root, this.table, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:table");
        }
        if (this.variantStrategy != null) {
            EPPUtil.encodeString(aDocument, root, this.variantStrategy.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:variantStrategy");
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.code = aElement.getAttribute(ATTR_CODE);
        this.table = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_TABLE_NAME);
        String theStrategyStr = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_VARIANT_STRATEGY_NAME);
        this.variantStrategy = theStrategyStr == null ? null : VariantStrategy.valueOf(theStrategyStr);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryLanguage)) {
            return false;
        }
        EPPRegistryLanguage theComp = (EPPRegistryLanguage)aObject;
        if (!EqualityUtil.equals(this.code, theComp.code)) {
            cat.error((Object)"EPPRegistryLanguage.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.table, theComp.table)) {
            cat.error((Object)"EPPRegistryLanguage.equals(): table not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.variantStrategy, (Object)theComp.variantStrategy)) {
            cat.error((Object)"EPPRegistryLanguage.equals(): variantStrategy not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String aTable) {
        this.table = aTable;
    }

    public VariantStrategy getVariantStrategy() {
        return this.variantStrategy;
    }

    public void setVariantStrategy(VariantStrategy aVariantStrategy) {
        this.variantStrategy = aVariantStrategy;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }

    public static enum VariantStrategy {
        blocked,
        restricted,
        open;

    }
}

