/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.v01.EPPRegistryDS;
import com.verisign.epp.codec.registry.v01.EPPRegistryKey;
import com.verisign.epp.codec.registry.v01.EPPRegistryMaxSig;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDNSSEC
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPRegistryDNSSEC.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "dnssec";
    public static final String ELM_NAME = "registry:dnssec";
    public static final String ELM_URGENT = "urgent";
    private EPPRegistryDS ds = null;
    private EPPRegistryKey key = null;
    private EPPRegistryMaxSig maxSigLife = null;
    private Boolean urgent = Boolean.FALSE;

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDNSSEC.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:registry-0.1", ELM_NAME);
        if (this.ds != null) {
            EPPUtil.encodeComp(aDocument, root, this.ds);
        } else {
            EPPUtil.encodeComp(aDocument, root, this.key);
        }
        EPPUtil.encodeComp(aDocument, root, this.maxSigLife);
        if (this.urgent == null) {
            this.urgent = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.urgent.toString(), "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:urgent");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.ds = (EPPRegistryDS)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:dsDataInterface", EPPRegistryDS.class);
        this.key = (EPPRegistryKey)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:keyDataInterface", EPPRegistryKey.class);
        this.maxSigLife = (EPPRegistryMaxSig)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", "registry:maxSigLife", EPPRegistryMaxSig.class);
        this.urgent = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:registry-0.1", ELM_URGENT);
        if (this.urgent == null) {
            this.urgent = Boolean.FALSE;
        }
    }

    void validateState() throws EPPCodecException {
        if (this.ds == null && this.key == null || this.ds != null && this.key != null) {
            throw new EPPCodecException("only one of dsDataInterface or keyDataInterface element is required");
        }
        if (this.maxSigLife == null) {
            throw new EPPCodecException("maxSigLife element is not set");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDNSSEC clone = (EPPRegistryDNSSEC)super.clone();
        if (this.ds != null) {
            clone.ds = (EPPRegistryDS)this.ds.clone();
        }
        if (this.key != null) {
            clone.key = (EPPRegistryKey)this.key.clone();
        }
        if (this.maxSigLife != null) {
            clone.maxSigLife = (EPPRegistryMaxSig)this.maxSigLife.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDNSSEC)) {
            return false;
        }
        EPPRegistryDNSSEC theComp = (EPPRegistryDNSSEC)aObject;
        if (!EqualityUtil.equals(this.ds, theComp.ds)) {
            cat.error((Object)"EPPRegistryDNSSEC.equals(): ds not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.key, theComp.key)) {
            cat.error((Object)"EPPRegistryDNSSEC.equals(): key not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.maxSigLife, theComp.maxSigLife)) {
            cat.error((Object)"EPPRegistryDNSSEC.equals(): maxSigLife not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.urgent, theComp.urgent)) {
            cat.error((Object)"EPPRegistryDNSSEC.equals(): urgent not equal");
            return false;
        }
        return true;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryDS getDs() {
        return this.ds;
    }

    public void setDs(EPPRegistryDS aDs) {
        this.ds = aDs;
    }

    public EPPRegistryKey getKey() {
        return this.key;
    }

    public void setKey(EPPRegistryKey aKey) {
        this.key = aKey;
    }

    public EPPRegistryMaxSig getMaxSigLife() {
        return this.maxSigLife;
    }

    public void setMaxSigLife(EPPRegistryMaxSig aMaxSigLife) {
        this.maxSigLife = aMaxSigLife;
    }

    public Boolean getUrgent() {
        return this.urgent;
    }

    public void setUrgent(Boolean aUrgent) {
        this.urgent = aUrgent;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:registry-0.1";
    }
}

