/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.orgext;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.orgext.EPPOrgExtAddRemChg;
import com.verisign.epp.codec.orgext.EPPOrgExtId;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPOrgExtUpdate
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPOrgExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "update";
    public static final String ELM_NAME = "orgext:update";
    EPPOrgExtAddRemChg addOrgs = null;
    EPPOrgExtAddRemChg remOrgs = null;
    EPPOrgExtAddRemChg chgOrgs = null;

    public EPPOrgExtUpdate() {
    }

    public EPPOrgExtUpdate(EPPOrgExtAddRemChg aAddOrgs, EPPOrgExtAddRemChg aRemOrgs, EPPOrgExtAddRemChg aChgOrgs) {
        this.addOrgs = aAddOrgs;
        this.remOrgs = aRemOrgs;
        this.chgOrgs = aChgOrgs;
    }

    public EPPOrgExtAddRemChg getAddOrgs() {
        return this.addOrgs;
    }

    public void setAddOrgs(EPPOrgExtAddRemChg aAddOrgs) {
        this.addOrgs = aAddOrgs;
    }

    public void addAddOrg(EPPOrgExtId aOrgId) {
        if (this.addOrgs == null) {
            this.addOrgs = new EPPOrgExtAddRemChg(EPPOrgExtAddRemChg.Action.ADD);
        }
        this.addOrgs.addOrgId(aOrgId);
    }

    public boolean hasAddOrgs() {
        return this.addOrgs != null && this.addOrgs.hasOrgIds();
    }

    public EPPOrgExtAddRemChg getRemOrgs() {
        return this.remOrgs;
    }

    public void setRemOrgs(EPPOrgExtAddRemChg aRemOrgs) {
        this.remOrgs = aRemOrgs;
    }

    public void addRemOrg(EPPOrgExtId aOrgId) {
        if (this.remOrgs == null) {
            this.remOrgs = new EPPOrgExtAddRemChg(EPPOrgExtAddRemChg.Action.REM);
        }
        this.remOrgs.addOrgId(aOrgId);
    }

    public boolean hasRemOrgs() {
        return this.remOrgs != null && this.remOrgs.hasOrgIds();
    }

    public EPPOrgExtAddRemChg getChgOrgs() {
        return this.chgOrgs;
    }

    public void setChgOrgs(EPPOrgExtAddRemChg aChgOrgs) {
        this.chgOrgs = aChgOrgs;
    }

    public void addChgOrg(EPPOrgExtId aOrgId) {
        if (this.chgOrgs == null) {
            this.chgOrgs = new EPPOrgExtAddRemChg(EPPOrgExtAddRemChg.Action.CHG);
        }
        this.chgOrgs.addOrgId(aOrgId);
    }

    public boolean hasChgOrgs() {
        return this.chgOrgs != null && this.chgOrgs.hasOrgIds();
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (!(this.hasAddOrgs() || this.hasRemOrgs() || this.hasChgOrgs())) {
            throw new EPPEncodeException("Empty add, remove, and change organizations in EPPOrgExtUpdate");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:orgext-1.0", ELM_NAME);
        if (this.hasAddOrgs()) {
            EPPUtil.encodeComp(aDocument, root, this.addOrgs);
        }
        if (this.hasRemOrgs()) {
            EPPUtil.encodeComp(aDocument, root, this.remOrgs);
        }
        if (this.hasChgOrgs()) {
            EPPUtil.encodeComp(aDocument, root, this.chgOrgs);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.addOrgs = (EPPOrgExtAddRemChg)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:orgext-1.0", "orgext:add", EPPOrgExtAddRemChg.class);
        this.remOrgs = (EPPOrgExtAddRemChg)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:orgext-1.0", "orgext:rem", EPPOrgExtAddRemChg.class);
        this.chgOrgs = (EPPOrgExtAddRemChg)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:epp:orgext-1.0", "orgext:chg", EPPOrgExtAddRemChg.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgExtUpdate clone = (EPPOrgExtUpdate)super.clone();
        if (this.addOrgs != null) {
            clone.addOrgs = (EPPOrgExtAddRemChg)this.addOrgs.clone();
        }
        if (this.remOrgs != null) {
            clone.remOrgs = (EPPOrgExtAddRemChg)this.remOrgs.clone();
        }
        if (this.chgOrgs != null) {
            clone.chgOrgs = (EPPOrgExtAddRemChg)this.chgOrgs.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgExtUpdate)) {
            return false;
        }
        EPPOrgExtUpdate other = (EPPOrgExtUpdate)aObject;
        if (!EqualityUtil.equals(this.addOrgs, other.addOrgs)) {
            cat.error((Object)"EPPOrgExtUpdate.equals(): addOrgs not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.remOrgs, other.remOrgs)) {
            cat.error((Object)"EPPOrgExtUpdate.equals(): remOrgs not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.chgOrgs, other.chgOrgs)) {
            cat.error((Object)"EPPOrgExtUpdate.equals(): chgOrgs not equal");
            return false;
        }
        return true;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:orgext-1.0";
    }
}

