/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.org.EPPOrgContact;
import com.verisign.epp.codec.org.EPPOrgPostalDefinition;
import com.verisign.epp.codec.org.EPPOrgRole;
import com.verisign.epp.codec.org.EPPOrgStatus;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPOrgCreateCmd
extends EPPCreateCmd {
    private static Logger cat = Logger.getLogger((String)EPPOrgCreateCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "create";
    public static final String ELM_NAME = "org:create";
    private static final String ELM_ORG_ID = "id";
    private static final String ELM_STATUS = "status";
    private static final String ELM_PARENT_ID = "parentId";
    private static final String ELM_VOICE = "voice";
    private static final String ELM_FAX = "fax";
    private static final String ELM_EMAIL = "email";
    private static final String ELM_URL = "url";
    private static final String ATTR_EXT = "x";
    private String orgId;
    private List<EPPOrgRole> roles = new ArrayList<EPPOrgRole>();
    private List<EPPOrgStatus> statuses = new ArrayList<EPPOrgStatus>();
    private String parentId;
    private List<EPPOrgPostalDefinition> postalInfo = new ArrayList<EPPOrgPostalDefinition>();
    private String voice;
    private String voiceExt;
    private String fax;
    private String faxExt;
    private String email;
    private String url;
    private List<EPPOrgContact> contacts = new ArrayList<EPPOrgContact>();

    public EPPOrgCreateCmd() {
    }

    public EPPOrgCreateCmd(String aTransId) {
        super(aTransId);
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String aOrgId) {
        this.orgId = aOrgId;
    }

    public boolean hasRole() {
        return !this.roles.isEmpty();
    }

    public List<EPPOrgRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<EPPOrgRole> aRoles) {
        this.roles = aRoles == null ? new ArrayList<EPPOrgRole>() : aRoles;
    }

    public void addRole(EPPOrgRole aRole) {
        this.roles.add(aRole);
    }

    public boolean hasStatus() {
        return !this.statuses.isEmpty();
    }

    public List<EPPOrgStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<EPPOrgStatus> aStatuses) {
        this.statuses = aStatuses == null ? new ArrayList<EPPOrgStatus>() : aStatuses;
    }

    public void addStatus(EPPOrgStatus aStatus) {
        this.statuses.add(aStatus);
    }

    public boolean hasParentId() {
        return this.parentId != null;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String aParentId) {
        this.parentId = aParentId;
    }

    public boolean hasPostalInfo() {
        return this.postalInfo != null && !this.postalInfo.isEmpty();
    }

    public void addPostalInfo(EPPOrgPostalDefinition aPostalInfo) {
        this.postalInfo.add(aPostalInfo);
    }

    public List<EPPOrgPostalDefinition> getPostalInfo() {
        return this.postalInfo;
    }

    public void setPostalInfo(List<EPPOrgPostalDefinition> aPostalInfo) {
        this.postalInfo = aPostalInfo == null ? new ArrayList<EPPOrgPostalDefinition>() : aPostalInfo;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getVoiceExt() {
        return this.voiceExt;
    }

    public void setVoiceExt(String aVoiceExt) {
        this.voiceExt = aVoiceExt;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getFaxExt() {
        return this.faxExt;
    }

    public void setFaxExt(String aFaxExt) {
        this.faxExt = aFaxExt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String aUrl) {
        this.url = aUrl;
    }

    public boolean hasContacts() {
        return this.contacts != null && !this.contacts.isEmpty();
    }

    public void addContact(EPPOrgContact aContact) {
        this.contacts.add(aContact);
    }

    public List<EPPOrgContact> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<EPPOrgContact> aContacts) {
        this.contacts = aContacts == null ? new ArrayList<EPPOrgContact>() : aContacts;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        Element theElm = null;
        Text theVal = null;
        if (this.orgId == null) {
            throw new EPPEncodeException("Undefined orgId in EPPOrgCreateCmd");
        }
        if (this.roles.isEmpty()) {
            throw new EPPEncodeException("No roles set in EPPOrgInfoResp");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.orgId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:id");
        EPPUtil.encodeCompList(aDocument, root, this.roles);
        EPPUtil.encodeList(aDocument, root, this.statuses, "urn:ietf:params:xml:ns:epp:org-1.0", "org:status");
        EPPUtil.encodeString(aDocument, root, this.parentId, "urn:ietf:params:xml:ns:epp:org-1.0", "org:parentId");
        EPPUtil.encodeCompList(aDocument, root, this.postalInfo);
        if (this.voice != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:voice");
            theVal = aDocument.createTextNode(this.voice);
            theElm.appendChild(theVal);
            if (this.voiceExt != null) {
                theElm.setAttribute(ATTR_EXT, this.voiceExt);
            }
            root.appendChild(theElm);
        }
        if (this.fax != null) {
            theElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", "org:fax");
            theVal = aDocument.createTextNode(this.fax);
            theElm.appendChild(theVal);
            if (this.faxExt != null) {
                theElm.setAttribute(ATTR_EXT, this.faxExt);
            }
            root.appendChild(theElm);
        }
        EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:epp:org-1.0", "org:email");
        EPPUtil.encodeString(aDocument, root, this.url, "urn:ietf:params:xml:ns:epp:org-1.0", "org:url");
        EPPUtil.encodeCompList(aDocument, root, this.contacts);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        Element theElm = null;
        this.orgId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_ORG_ID);
        this.roles = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:role", EPPOrgRole.class);
        this.statuses = EPPUtil.decodeEnumList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_STATUS, EPPOrgStatus.class);
        this.parentId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_PARENT_ID);
        this.postalInfo = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:postalInfo", EPPOrgPostalDefinition.class);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_VOICE);
        if (theElm != null) {
            this.voice = EPPUtil.getTextContent(theElm);
            this.voiceExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.voice = null;
            this.voiceExt = null;
        }
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_FAX);
        if (theElm != null) {
            this.fax = EPPUtil.getTextContent(theElm);
            this.faxExt = EPPUtil.decodeStringAttr(theElm, ATTR_EXT);
        } else {
            this.fax = null;
            this.faxExt = null;
        }
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_EMAIL);
        this.url = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", ELM_URL);
        this.contacts = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:epp:org-1.0", "org:contact", EPPOrgContact.class);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgCreateCmd clone = (EPPOrgCreateCmd)super.clone();
        clone.roles = (List)((ArrayList)this.roles).clone();
        if (this.hasStatus()) {
            clone.statuses = (List)((ArrayList)this.statuses).clone();
        }
        if (this.hasPostalInfo()) {
            clone.postalInfo = (List)((ArrayList)this.postalInfo).clone();
        }
        if (this.hasContacts()) {
            clone.contacts = (List)((ArrayList)this.contacts).clone();
        }
        return clone;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgCreateCmd)) {
            return false;
        }
        EPPOrgCreateCmd other = (EPPOrgCreateCmd)aObject;
        if (!EqualityUtil.equals(this.orgId, other.orgId)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): orgId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.roles, other.roles)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): roles not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.statuses, other.statuses)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): statuses not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.parentId, other.parentId)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): parentId not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.postalInfo, other.postalInfo)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): postalInfo not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voice, other.voice)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): voice not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.voiceExt, other.voiceExt)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): voiceExt not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.fax, other.fax)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): fax not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.faxExt, other.faxExt)) {
            cat.error((Object)("EPPOrgCreateCmd.equals(): faxExt not equal, this.faxExt = " + this.faxExt + ", other.faxExt = " + other.faxExt));
            return false;
        }
        if (!EqualityUtil.equals(this.email, other.email)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): email not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.url, other.url)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): url not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.contacts, other.contacts)) {
            cat.error((Object)"EPPOrgCreateCmd.equals(): contacts not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

