/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.org;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.security.InvalidParameterException;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPOrgContact
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPOrgContact.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "contact";
    public static final String ELM_NAME = "org:contact";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_TYPE_NAME = "typeName";
    private Type type;
    private String contactId;
    private String typeName;

    public EPPOrgContact() {
    }

    public EPPOrgContact(String aContactId, Type aType) {
        this.contactId = aContactId;
        this.type = aType;
    }

    public EPPOrgContact(String aContactId, Type aType, String aTypeName) {
        this.contactId = aContactId;
        this.type = aType;
        this.typeName = aTypeName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type aType) {
        this.type = aType;
    }

    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String aContactId) {
        this.contactId = aContactId;
    }

    public boolean hasTypeName() {
        return this.typeName != null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String aTypeName) {
        this.typeName = aTypeName;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:org-1.0", ELM_NAME);
        if (this.type == null) {
            throw new EPPEncodeException("EPPOrgContact type is null on call to encode");
        }
        if (this.contactId == null) {
            throw new EPPEncodeException("EPPOrgContact contactId is null on call to encode");
        }
        root.setAttribute(ATTR_TYPE, this.type.toString());
        Text textNode = aDocument.createTextNode(this.contactId);
        root.appendChild(textNode);
        if (this.hasTypeName()) {
            root.setAttribute(ATTR_TYPE_NAME, this.typeName);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.type = Type.getType(aElement.getAttribute(ATTR_TYPE));
        this.contactId = aElement.getFirstChild().getNodeValue();
        this.typeName = EPPUtil.decodeStringAttr(aElement, ATTR_TYPE_NAME);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPOrgContact)) {
            return false;
        }
        EPPOrgContact theComp = (EPPOrgContact)aObject;
        if (!EqualityUtil.equals((Object)this.type, (Object)theComp.type)) {
            cat.error((Object)"EPPOrgContact.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.contactId, theComp.contactId)) {
            cat.error((Object)"EPPOrgContact.equals(): contactId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.typeName, theComp.typeName)) {
            cat.error((Object)"EPPOrgContact.equals(): typeName not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPOrgContact clone = null;
        clone = (EPPOrgContact)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    public static enum Type {
        ADMINISTRATIVE("admin"),
        BILLING("billing"),
        TECHNICAL("tech"),
        ABUSE("abuse"),
        CUSTOM("custom");

        private final String typeVal;

        private Type(String aTypeVal) {
            this.typeVal = aTypeVal;
        }

        public static Type getType(String aTypeVal) {
            if (aTypeVal == null || aTypeVal.isEmpty()) {
                throw new InvalidParameterException("Type value of null or empty is not valid.");
            }
            if (aTypeVal.equals(Type.ADMINISTRATIVE.typeVal)) {
                return ADMINISTRATIVE;
            }
            if (aTypeVal.equals(Type.BILLING.typeVal)) {
                return BILLING;
            }
            if (aTypeVal.equals(Type.TECHNICAL.typeVal)) {
                return TECHNICAL;
            }
            if (aTypeVal.equals(Type.ABUSE.typeVal)) {
                return ABUSE;
            }
            if (aTypeVal.equals(Type.CUSTOM.typeVal)) {
                return CUSTOM;
            }
            throw new InvalidParameterException("Type enum value of " + aTypeVal + " is not valid.");
        }

        public String toString() {
            return this.typeVal;
        }
    }
}

