/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nv;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nv.EPPNameVerificationStatus;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPNameVerificationPendActionMsg
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPNameVerificationPendActionMsg.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "panData";
    public static final String ELM_NAME = "nv:panData";
    private static final String ELM_CODE = "code";
    private static final String ATTR_TYPE = "type";
    private static final String ELM_STATUS = "paStatus";
    private static final String ATTR_STATUS = "s";
    private static final String ELM_MSG = "msg";
    private static final String ELM_PA_DATE = "paDate";
    private String code;
    private String type;
    private EPPNameVerificationStatus status;
    private String msg;
    private Date paDate;

    public EPPNameVerificationPendActionMsg() {
    }

    public EPPNameVerificationPendActionMsg(EPPTransId aTransId, String aCode, String aType, EPPNameVerificationStatus aStatus, String aMsg, Date aPaDate) {
        super(aTransId);
        this.code = aCode;
        this.type = aType;
        this.status = aStatus;
        this.msg = aMsg;
        this.paDate = aPaDate;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:nv-1.0";
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public String getCodeType() {
        return this.type;
    }

    public void setCodeType(String aType) {
        this.type = aType;
    }

    public EPPNameVerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPNameVerificationStatus aStatus) {
        this.status = aStatus;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String aMsg) {
        this.msg = aMsg;
    }

    public Date getPaDate() {
        return this.paDate;
    }

    public void setPaDate(Date aPaDate) {
        this.paDate = aPaDate;
    }

    void validateState() throws EPPCodecException {
        if (this.code == null) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.validateState(): required attribute code is not set");
            throw new EPPCodecException("required attribute code is not set");
        }
        if (this.type == null) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.validateState(): required attribute type is not set");
            throw new EPPCodecException("required attribute type is not set");
        }
        if (this.status == null) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.validateState(): required attribute status is not set");
            throw new EPPCodecException("required attribute status is not set");
        }
        if (this.msg == null) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.validateState(): required attribute msg is not set");
            throw new EPPCodecException("required attribute msg is not set");
        }
        if (this.paDate == null) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.validateState(): required attribute paDate is not set");
            throw new EPPCodecException("required attribute paDate is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPNameVerificationPendActionMsg.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", ELM_NAME);
        Element code = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:code");
        Text codeVal = aDocument.createTextNode(this.code);
        code.appendChild(codeVal);
        root.appendChild(code);
        code.setAttribute(ATTR_TYPE, this.type);
        Element theStatusElm = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:paStatus");
        root.appendChild(theStatusElm);
        theStatusElm.setAttribute(ATTR_STATUS, this.status.toString());
        Element reason = aDocument.createElementNS("urn:ietf:params:xml:ns:nv-1.0", "nv:msg");
        Text reasonVal = aDocument.createTextNode(this.msg);
        reason.appendChild(reasonVal);
        root.appendChild(reason);
        EPPUtil.encodeTimeInstant(aDocument, root, this.paDate, "urn:ietf:params:xml:ns:nv-1.0", "nv:paDate");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        Element theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_CODE);
        this.type = theElm.getAttribute(ATTR_TYPE);
        theElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_STATUS);
        String theStatusStr = theElm.getAttribute(ATTR_STATUS);
        this.status = EPPNameVerificationStatus.getStatus(theStatusStr);
        this.msg = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_MSG);
        this.paDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:nv-1.0", ELM_PA_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPNameVerificationPendActionMsg.decode: " + e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameVerificationPendActionMsg clone = (EPPNameVerificationPendActionMsg)super.clone();
        return clone;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameVerificationPendActionMsg)) {
            return false;
        }
        EPPNameVerificationPendActionMsg other = (EPPNameVerificationPendActionMsg)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.type, other.type)) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.equals(): type not equal");
            return false;
        }
        if (!EqualityUtil.equals((Object)this.status, (Object)other.status)) {
            cat.error((Object)"EPPNameVerificationPendActionMsg.equals(): status not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.msg, other.msg)) {
            cat.error((Object)"EPPNameVerificationCreateFailed.equals(): msg not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.paDate, other.paDate)) {
            cat.error((Object)"EPPNameVerificationCreateFailed.equals(): paDate not equal");
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

