/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.nameWatch.EPPNameWatchAddRemove;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchDeleteCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchPeriod;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRenewResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRptTo;
import com.verisign.epp.codec.nameWatch.EPPNameWatchStatus;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.util.TestThread;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPNameWatchTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPNameWatchTst(String name) {
        super(name);
    }

    public void testNameWatchInfo() {
        EPPCodecTst.printStart("testNameWatchInfo");
        EPPNameWatchInfoCmd theCommand = new EPPNameWatchInfoCmd("ABC-12349", "EXAMPLE1-REP");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPNameWatchStatus> statuses = new Vector<EPPNameWatchStatus>();
        statuses.addElement(new EPPNameWatchStatus("ok"));
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPNameWatchInfoResp theResponse = new EPPNameWatchInfoResp(respTransId, "doe", "EXAMPLE1-REP", "jd1234", new EPPNameWatchRptTo("weekly", "jdoe@example.com"), statuses, "ClientX", "ClientY", new GregorianCalendar(1999, 4, 3).getTime(), new GregorianCalendar(2002, 4, 3).getTime());
        theResponse.setAuthInfo(new EPPAuthInfo("2fooBAR"));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3).getTime());
        theResponse.setLastTransferDate(new GregorianCalendar(2000, 4, 8).getTime());
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse.setTransId(respTransId);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theResponse = new EPPNameWatchInfoResp();
        theResponse.setName("doe");
        theResponse.setRoid("EXAMPLE1-REP");
        theResponse.setClientId("ClientX");
        respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        theResponse.setTransId(respTransId);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testNameWatchInfo");
    }

    public void testNameWatchCreate() {
        EPPCodecTst.printStart("testNameWatchCreate");
        EPPNameWatchCreateCmd theCommand = new EPPNameWatchCreateCmd("ABC-12345", "doe", "jd1234", new EPPNameWatchRptTo("weekly", "jdoe@example.com"), new EPPAuthInfo("2fooBAR"));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand.setPeriod(new EPPNameWatchPeriod(1));
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPNameWatchCreateResp theResponse = new EPPNameWatchCreateResp(respTransId, "doe", "EXAMPLE1-REP", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testNameWatchCreate");
    }

    public void testNameWatchDelete() {
        EPPCodecTst.printStart("testNameWatchDelete");
        EPPNameWatchDeleteCmd theCommand = new EPPNameWatchDeleteCmd("ABC-12345", "EXAMPLE1-REP");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testNameWatchDelete");
    }

    public void testNameWatchRenew() {
        EPPCodecTst.printStart("testNameWatchRenew");
        Calendar theCal = Calendar.getInstance();
        theCal.setTimeZone(TimeZone.getTimeZone("UTC"));
        theCal.set(2000, 6, 22, 0, 0, 0);
        theCal.set(14, 0);
        Date theDate = theCal.getTime();
        EPPNameWatchRenewCmd theCommand = new EPPNameWatchRenewCmd("ABC-12345", "EXAMPLE1-REP", theDate, new EPPNameWatchPeriod(5));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPNameWatchRenewResp theResponse = new EPPNameWatchRenewResp(respTransId, "EXAMPLE1-REP", new GregorianCalendar(2000, 4, 3).getTime());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testNameWatchRenew");
    }

    public void testNameWatchUpate() {
        EPPCodecTst.printStart("testNameWatchUpate");
        Vector<EPPNameWatchStatus> addStatuses = new Vector<EPPNameWatchStatus>();
        addStatuses.addElement(new EPPNameWatchStatus("clientHold", "en"));
        Vector<EPPNameWatchStatus> removeStatuses = new Vector<EPPNameWatchStatus>();
        removeStatuses.addElement(new EPPNameWatchStatus("clientHold"));
        EPPNameWatchAddRemove addItems = new EPPNameWatchAddRemove(addStatuses);
        EPPNameWatchAddRemove removeItems = new EPPNameWatchAddRemove(removeStatuses);
        EPPNameWatchAddRemove changeItems = new EPPNameWatchAddRemove("SH8013", new EPPNameWatchRptTo("daily", "jdoe@example.com"), new EPPAuthInfo("2fooBAR"));
        EPPNameWatchUpdateCmd theCommand = new EPPNameWatchUpdateCmd("ABC-12345-XYZ", "EXAMPLE1-REP", addItems, removeItems, changeItems);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testNameWatchUpate");
    }

    public void testNameWatchTransfer() {
        EPPCodecTst.printStart("testNameWatchTransfer");
        EPPNameWatchTransferCmd theCommand = new EPPNameWatchTransferCmd("ABC-12345", "request", "EXAMPLE1-REP", new EPPAuthInfo("2fooBAR"), new EPPNameWatchPeriod(1));
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPNameWatchTransferResp theResponse = new EPPNameWatchTransferResp(respTransId, "EXAMPLE1-REP");
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus("pending");
        theResponse.setRequestDate(new GregorianCalendar(2000, 6, 8).getTime());
        theResponse.setActionDate(new GregorianCalendar(2000, 6, 13).getTime());
        theResponse.setExpirationDate(new GregorianCalendar(2002, 9, 8).getTime());
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        theCommand = new EPPNameWatchTransferCmd("ABC-12345", "cancel", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPNameWatchTransferCmd("ABC-12345", "query", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPNameWatchTransferCmd("ABC-12345", "reject", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        theCommand = new EPPNameWatchTransferCmd("ABC-12345", "approve", "EXAMPLE1-REP");
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testNameWatchTransfer");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPNameWatchTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.nameWatch.EPPNameWatchMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPNameWatchMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPNameWatchTst Thread " + i, EPPNameWatchTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPNameWatchTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

