/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPTransferCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nameWatch.EPPNameWatchPeriod;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameWatchTransferCmd
extends EPPTransferCmd {
    static final String ELM_NAME = "nameWatch:transfer";
    private static final String ELM_ROID = "nameWatch:roid";
    private String roid = null;
    private EPPNameWatchPeriod period = null;
    private EPPAuthInfo authInfo = null;

    public EPPNameWatchTransferCmd() {
        this.roid = null;
        this.period = null;
        this.authInfo = null;
    }

    public EPPNameWatchTransferCmd(String aTransId, String aOp, String aRoid) {
        super(aTransId, aOp);
        this.roid = aRoid;
    }

    public EPPNameWatchTransferCmd(String aTransId, String aOp, String aRoid, EPPAuthInfo aAuthInfo) {
        super(aTransId, aOp);
        this.roid = aRoid;
        this.setAuthInfo(aAuthInfo);
    }

    public EPPNameWatchTransferCmd(String aTransId, String aOp, String aRoid, EPPAuthInfo aAuthInfo, EPPNameWatchPeriod aPeriod) {
        super(aTransId, aOp);
        this.roid = aRoid;
        this.period = aPeriod;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/nameWatch-1.0";
    }

    void validateState() throws EPPCodecException {
        if (super.getOp() == null) {
            throw new EPPCodecException("op required attribute is not set");
        }
        if (this.roid == null) {
            throw new EPPCodecException("roid required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPNameWatchTransferCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_NAME);
        root.setAttribute("xmlns:nameWatch", "http://www.nic.name/epp/nameWatch-1.0");
        EPPUtil.encodeString(aDocument, root, this.roid, "http://www.nic.name/epp/nameWatch-1.0", ELM_ROID);
        EPPUtil.encodeComp(aDocument, root, this.period);
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.roid = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_ROID);
        this.period = (EPPNameWatchPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", "nameWatch:period", EPPNameWatchPeriod.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo", EPPAuthInfo.class);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPNameWatchTransferCmd.decode: " + e);
        }
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameWatchTransferCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPNameWatchTransferCmd theMap = (EPPNameWatchTransferCmd)aObject;
        if (!(this.roid != null ? this.roid.equals(theMap.roid) : theMap.roid == null)) {
            return false;
        }
        if (!(this.period != null ? this.period.equals(theMap.period) : theMap.period == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theMap.authInfo) : theMap.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameWatchTransferCmd clone = (EPPNameWatchTransferCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPNameWatchPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPNameWatchPeriod getPeriod() {
        return this.period;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo");
        }
    }

    public void setPeriod(EPPNameWatchPeriod aPeriod) {
        this.period = aPeriod;
    }
}

