/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.nameWatch.EPPNameWatchRptTo;
import com.verisign.epp.codec.nameWatch.EPPNameWatchStatus;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPNameWatchAddRemove
implements EPPCodecComponent {
    static final short MODE_NONE = 0;
    static final short MODE_ADD = 1;
    static final short MODE_REMOVE = 2;
    static final short MODE_CHANGE = 3;
    static final String ELM_ADD = "nameWatch:add";
    static final String ELM_REMOVE = "nameWatch:rem";
    static final String ELM_CHANGE = "nameWatch:chg";
    private static final String ELM_REGISTRANT = "nameWatch:registrant";
    private static final String ELM_RPTTO = "nameWatch:rptTo";
    private static final String ELM_STATUS = "nameWatch:status";
    private short mode = 0;
    private Vector statuses = null;
    private String registrant = null;
    private EPPNameWatchRptTo rptTo = null;
    private EPPAuthInfo authInfo = null;

    public EPPNameWatchAddRemove() {
        this.registrant = null;
        this.authInfo = null;
        this.rptTo = null;
        this.statuses = null;
    }

    public EPPNameWatchAddRemove(Vector aStatuses) {
        this.statuses = aStatuses;
    }

    public EPPNameWatchAddRemove(String aRegistrant, EPPNameWatchRptTo aRptTo, EPPAuthInfo aAuthInfo) {
        this.registrant = aRegistrant;
        this.rptTo = aRptTo;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = null;
        if (this.mode == 3) {
            root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_CHANGE);
            if (this.registrant != null) {
                EPPUtil.encodeString(aDocument, root, this.registrant, "http://www.nic.name/epp/nameWatch-1.0", ELM_REGISTRANT);
            }
            if (this.rptTo != null && !this.rptTo.isRptToUnspec()) {
                EPPUtil.encodeComp(aDocument, root, this.rptTo);
            }
            if (this.authInfo != null) {
                EPPUtil.encodeComp(aDocument, root, this.authInfo);
            }
            return root;
        }
        if (this.mode == 1) {
            root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_ADD);
        } else if (this.mode == 2) {
            root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_REMOVE);
        } else {
            throw new EPPEncodeException("Invalid EPPNameWatchAddRemove mode of " + this.mode);
        }
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_ADD))) {
            this.mode = 1;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_REMOVE))) {
            this.mode = (short)2;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_CHANGE))) {
            this.mode = (short)3;
        } else {
            throw new EPPDecodeException("Invalid EPPNameWatchAddRemove mode of " + aElement.getLocalName());
        }
        if (this.mode == 3) {
            this.registrant = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_REGISTRANT);
            this.rptTo = (EPPNameWatchRptTo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_RPTTO, EPPNameWatchRptTo.class);
            this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo", EPPAuthInfo.class);
        } else {
            this.statuses = EPPUtil.decodeCompVector(aElement, "http://www.nic.name/epp/nameWatch-1.0", ELM_STATUS, EPPNameWatchStatus.class);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameWatchAddRemove)) {
            return false;
        }
        EPPNameWatchAddRemove theComp = (EPPNameWatchAddRemove)aObject;
        if (this.mode != theComp.mode) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null)) {
            return false;
        }
        if (!(this.rptTo != null ? this.rptTo.equals(theComp.rptTo) : theComp.rptTo == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPNameWatchAddRemove clone = null;
        clone = (EPPNameWatchAddRemove)super.clone();
        if (this.statuses != null) {
            clone.statuses = (Vector)this.statuses.clone();
        }
        if (this.registrant != null) {
            clone.registrant = this.registrant;
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.rptTo != null) {
            clone.rptTo = (EPPNameWatchRptTo)this.rptTo.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public EPPNameWatchRptTo getRptTo() {
        return this.rptTo;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector aStatuses) {
        this.statuses = aStatuses;
    }

    public void setRptTo(EPPNameWatchRptTo aRptTo) {
        if (aRptTo != null) {
            this.rptTo = aRptTo;
        }
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/nameWatch-1.0", "nameWatch:authInfo");
        }
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    short getMode() {
        return this.mode;
    }

    void setMode(short aMode) {
        this.mode = aMode;
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/nameWatch-1.0";
    }
}

