/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.loginsecpolicy.v04;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLoginSecPolicyPassword
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLoginSecPolicyPassword.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "pw";
    public static final String ELM_NAME = "loginSecPolicy:pw";
    public static final String DEFAULT_LANG = "en";
    private static final String ELM_EXPRESSION = "expression";
    private static final String ELM_DESCRIPTION = "description";
    private static final String ELM_SPECIAL_RULES = "specialRules";
    private static final String ELM_RESTRICTED_WORDS = "restrictedWords";
    private static final String ATTR_RESTRICTED_WORDS_URL = "url";
    public static final String ATTR_LANG = "lang";
    private String expression = null;
    private String lang = "en";
    private String description = null;
    private Boolean specialRules = Boolean.FALSE;
    private Boolean restrictedWords = Boolean.FALSE;
    private String restrictedWordsUrl = null;

    public EPPLoginSecPolicyPassword() {
    }

    public EPPLoginSecPolicyPassword(String aExpression) {
        this.expression = aExpression;
    }

    public EPPLoginSecPolicyPassword(String aExpression, String aLang, String aDescription) {
        this.expression = aExpression;
        this.setLang(aLang);
        this.description = aDescription;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.expression == null) {
            throw new EPPEncodeException("expression is null in EPPLoginSecPolicyPassword.encode(Document).");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.expression, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:expression");
        if (this.hasDescription()) {
            Element theDescriptionElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:description");
            theDescriptionElm.setAttribute(ATTR_LANG, this.lang);
            Text theDescText = aDocument.createTextNode(this.description);
            theDescriptionElm.appendChild(theDescText);
            root.appendChild(theDescriptionElm);
        }
        if (!this.hasSpecialRules()) {
            this.specialRules = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.specialRules.toString(), "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:specialRules");
        if (!this.hasRestrictedWords()) {
            this.restrictedWords = Boolean.FALSE;
        }
        Element theRestrictedWordsElm = aDocument.createElementNS("urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", "loginSecPolicy:restrictedWords");
        Text theRestrictedWordsValue = aDocument.createTextNode(this.restrictedWords.toString());
        theRestrictedWordsElm.appendChild(theRestrictedWordsValue);
        root.appendChild(theRestrictedWordsElm);
        if (this.hasRestrictedWords() && this.restrictedWords == Boolean.TRUE && this.hasRestrictedWordsUrl()) {
            theRestrictedWordsElm.setAttribute(ATTR_RESTRICTED_WORDS_URL, this.restrictedWordsUrl);
        }
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.expression = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_EXPRESSION);
        Element theDescriptionElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_DESCRIPTION);
        if (theDescriptionElm != null) {
            this.setLang(EPPUtil.decodeStringAttr(theDescriptionElm, ATTR_LANG));
            this.description = EPPUtil.getTextContent(theDescriptionElm, true);
            if (this.description != null && this.description.isEmpty()) {
                this.description = null;
            }
        }
        this.specialRules = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_SPECIAL_RULES);
        if (this.specialRules == null) {
            this.specialRules = Boolean.FALSE;
        }
        this.restrictedWords = EPPUtil.decodeBoolean(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_RESTRICTED_WORDS);
        if (this.restrictedWords == null) {
            this.restrictedWords = Boolean.FALSE;
        }
        if (this.restrictedWords == Boolean.TRUE) {
            Element theRestrictedWordsElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4", ELM_RESTRICTED_WORDS);
            this.restrictedWordsUrl = EPPUtil.decodeStringAttr(theRestrictedWordsElm, ATTR_RESTRICTED_WORDS_URL);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLoginSecPolicyPassword)) {
            return false;
        }
        EPPLoginSecPolicyPassword theComp = (EPPLoginSecPolicyPassword)aObject;
        if (!EqualityUtil.equals(this.expression, theComp.expression)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): expression not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.lang, theComp.lang)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): lang not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.description, theComp.description)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): description not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.specialRules, theComp.specialRules)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): specialRules not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.restrictedWords, theComp.restrictedWords)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): restrictedWords not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.restrictedWordsUrl, theComp.restrictedWordsUrl)) {
            cat.error((Object)"EPPLoginSecPolicyPassword.equals(): restrictedWordsUrl not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String aExpression) {
        this.expression = aExpression;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String aLang) {
        this.lang = aLang == null ? DEFAULT_LANG : aLang;
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDesc) {
        this.description = aDesc;
    }

    public boolean hasSpecialRules() {
        return this.specialRules != null;
    }

    public Boolean getSpecialRules() {
        return this.specialRules;
    }

    public void setSpecialRules(Boolean aSpecialRules) {
        this.specialRules = aSpecialRules;
    }

    public boolean hasRestrictedWords() {
        return this.restrictedWords != null;
    }

    public Boolean getRestrictedWords() {
        return this.restrictedWords;
    }

    public void setRestrictedWords(Boolean aRestrictedWords) {
        this.restrictedWords = aRestrictedWords;
    }

    public boolean hasRestrictedWordsUrl() {
        return this.restrictedWordsUrl != null;
    }

    public String getRestrictedWordsUrl() {
        return this.restrictedWordsUrl;
    }

    public void setRestrictedWordsUrl(String aRestrictedWordsUrl) {
        this.restrictedWordsUrl = aRestrictedWordsUrl;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:loginSecPolicy-0.4";
    }
}

