/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.loginsec.v04;

import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.loginsec.v04.EPPLoginSec;
import com.verisign.epp.codec.loginsec.v04.EPPLoginSecData;
import com.verisign.epp.codec.loginsec.v04.EPPLoginSecEvent;
import com.verisign.epp.codec.loginsec.v04.EPPLoginSecUserAgent;
import com.verisign.epp.codec.loginsec.v04.EventLevel;
import com.verisign.epp.codec.loginsec.v04.EventType;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.util.TestThread;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPLoginSecTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static long numIterations = 1L;
    private static String configFileName = "epp.config";

    public EPPLoginSecTst(String name) {
        super(name);
    }

    public void testLoginCmdLongPwd() {
        EPPCodecTst.printStart("testLoginCmdLongPwd");
        Vector<EPPService> services = new Vector<EPPService>();
        EPPService service = new EPPService("obj1", "urn:ietf:params:xml:ns:obj1");
        service.setServiceType(0);
        services.addElement(service);
        Vector<EPPService> extservices = new Vector<EPPService>();
        EPPService extservice = new EPPService("loginSec", "urn:ietf:params:xml:ns:loginSec-0.4");
        extservice.setServiceType(1);
        extservices.addElement(extservice);
        EPPLoginCmd theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "[LOGIN-SECURITY]");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        EPPLoginSec theExt = new EPPLoginSec(new EPPLoginSecUserAgent("EPP SDK 1.0.0", "Java 11.0.2", "x86_64 Mac OS X 10.11.6"));
        theCommand.addExtension(theExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLoginCmdLongPwd");
    }

    public void testLoginCmdLongNewPwd() {
        EPPCodecTst.printStart("testLoginCmdLongNewPwd");
        Vector<EPPService> services = new Vector<EPPService>();
        EPPService service = new EPPService("obj1", "urn:ietf:params:xml:ns:obj1");
        service.setServiceType(0);
        services.addElement(service);
        Vector<EPPService> extservices = new Vector<EPPService>();
        EPPService extservice = new EPPService("loginSec", "urn:ietf:params:xml:ns:loginSec-0.1");
        extservice.setServiceType(1);
        extservices.addElement(extservice);
        EPPLoginCmd theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "shortpassword", "[LOGIN-SECURITY]");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        EPPLoginSec theExt = new EPPLoginSec();
        theExt.setNewPassword("new password that is long");
        theCommand.addExtension(theExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLoginCmdLongNewPwd");
    }

    public void testLoginCmdLongPwdNewPwd() {
        EPPCodecTst.printStart("testLoginCmdLongPwdNewPwd");
        Vector<EPPService> services = new Vector<EPPService>();
        EPPService service = new EPPService("obj1", "urn:ietf:params:xml:ns:obj1");
        service.setServiceType(0);
        services.addElement(service);
        Vector<EPPService> extservices = new Vector<EPPService>();
        EPPService extservice = new EPPService("loginSec", "urn:ietf:params:xml:ns:loginSec-0.1");
        extservice.setServiceType(1);
        extservices.addElement(extservice);
        EPPLoginCmd theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "[LOGIN-SECURITY]", "[LOGIN-SECURITY]");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        EPPLoginSec theExt = new EPPLoginSec(null, "this is a long password", "new password that is still long");
        theCommand.addExtension(theExt);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testLoginCmdLongPwdNewPwd");
    }

    public void testExpiringPasswordResponse() {
        EPPCodecTst.printStart("testExpiringPasswordResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(theTransId);
        theResponse.setResult(1000);
        EPPLoginSecData loginSecData = new EPPLoginSecData();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(System.currentTimeMillis()));
        ((Calendar)calendar).add(6, 7);
        EPPLoginSecEvent passwordExpiryEvent = new EPPLoginSecEvent(EventType.PASSWORD, EventLevel.WARNING, calendar.getTime(), "Password expiring in a week");
        loginSecData.addEvent(passwordExpiryEvent);
        theResponse.addExtension(loginSecData);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testExpiringPasswordResponse");
    }

    public void testExpiredPasswordResponse() {
        EPPCodecTst.printStart("testExpiredPasswordResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(theTransId);
        theResponse.setResult(2200);
        EPPLoginSecData loginSecData = new EPPLoginSecData();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(System.currentTimeMillis()));
        ((Calendar)calendar).add(6, -1);
        EPPLoginSecEvent passwordExpiryEvent = new EPPLoginSecEvent(EventType.PASSWORD, EventLevel.ERROR, calendar.getTime(), "Password has expired");
        loginSecData.addEvent(passwordExpiryEvent);
        theResponse.addExtension(loginSecData);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testExpiredPasswordResponse");
    }

    public void testWarningAllResponse() {
        EPPCodecTst.printStart("testWarningAllResponse");
        EPPTransId theTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(theTransId);
        theResponse.setResult(1000);
        EPPLoginSecData loginSecData = new EPPLoginSecData();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date(System.currentTimeMillis()));
        ((Calendar)calendar).add(6, 7);
        EPPLoginSecEvent theEvent = new EPPLoginSecEvent(EventType.PASSWORD, EventLevel.WARNING, calendar.getTime(), "Password expiring in a week");
        loginSecData.addEvent(theEvent);
        calendar = new GregorianCalendar();
        calendar.setTime(new Date(System.currentTimeMillis()));
        ((Calendar)calendar).add(6, 5);
        theEvent = new EPPLoginSecEvent(EventType.CERTIFICATE, EventLevel.WARNING, calendar.getTime(), null);
        loginSecData.addEvent(theEvent);
        theEvent = new EPPLoginSecEvent(EventType.CIPHER, EventLevel.WARNING, "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "Insecure cipher negotiated");
        loginSecData.addEvent(theEvent);
        theEvent = new EPPLoginSecEvent(EventType.TLS_PROTOCOL, EventLevel.WARNING, "SSLv3", "Insecure TLS protocol negotiated");
        loginSecData.addEvent(theEvent);
        theEvent = new EPPLoginSecEvent(EventType.NEW_PW, EventLevel.ERROR, "New password does not meet complexity requirements");
        loginSecData.addEvent(theEvent);
        theEvent = new EPPLoginSecEvent(EventType.STAT, "failedLogins", EventLevel.WARNING, "100", "P1D", "100 invalid logins over 1 day");
        loginSecData.addEvent(theEvent);
        theEvent = new EPPLoginSecEvent(EventType.CUSTOM, "myCustomEvent", EventLevel.WARNING, "A custom login security event occured");
        loginSecData.addEvent(theEvent);
        theResponse.addExtension(loginSecData);
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(commandStats);
        EPPCodecTst.printEnd("testWarningAllResponse");
    }

    public void testNegativePassword() {
        EPPCodecTst.printStart("testNegativePassword");
        Vector<EPPService> services = new Vector<EPPService>();
        EPPService service = new EPPService("obj1", "urn:ietf:params:xml:ns:obj1");
        service.setServiceType(0);
        services.addElement(service);
        Vector<EPPService> extservices = new Vector<EPPService>();
        EPPService extservice = new EPPService("loginSec", "urn:ietf:params:xml:ns:loginSec-0.1");
        extservice.setServiceType(1);
        extservices.addElement(extservice);
        EPPLoginCmd theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "01234567890123456");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        try {
            EPPCodecTst.testXMLEncodeDecode(theCommand, null);
            Assert.fail((String)"Base login password longer than the 16 character maximum should have failed");
        }
        catch (EPPException ex) {
            System.out.println("Received expected exception with long password: " + ex);
        }
        theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "0123456789012345", "01234567890123456");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        try {
            EPPCodecTst.testXMLEncodeDecode(theCommand, null);
            Assert.fail((String)"Base login new password longer than the 16 character maximum should have failed");
        }
        catch (EPPException ex) {
            System.out.println("Received expected exception with long new password: " + ex);
        }
        theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "[LOGIN-SECURITY]", "[LOGIN-SECURITY]");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        theCommand.addExtension(new EPPLoginSec(null, "0123456"));
        try {
            EPPCodecTst.testXMLEncodeDecode(theCommand, null);
            Assert.fail((String)"Login Security Extension with password shorter than the 8 character minimum should have failed");
        }
        catch (EPPException ex) {
            System.out.println("Received expected exception with short Login Security Extension password: " + ex);
        }
        theCommand = new EPPLoginCmd("ABC-12345", "ClientX", "[LOGIN-SECURITY]", "[LOGIN-SECURITY]");
        theCommand.setServices(services);
        theCommand.setExtensionServices(extservices);
        theCommand.setVersion("1.0");
        theCommand.setLang("en");
        theCommand.addExtension(new EPPLoginSec(null, "01234567", "0123456"));
        try {
            EPPCodecTst.testXMLEncodeDecode(theCommand, null);
            Assert.fail((String)"Login Security Extension new password shorter than the 8 character minimum should have failed");
        }
        catch (EPPException ex) {
            System.out.println("Received expected exception with short Login Security Extension new password: " + ex);
        }
        EPPCodecTst.printEnd("testNegativePassword");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPLoginSecTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPLoginSecTst Thread " + i, EPPLoginSecTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPLoginSecTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

