/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.host.EPPHostCheckCmd;
import com.verisign.epp.codec.host.EPPHostCheckResp;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostCreateResp;
import com.verisign.epp.codec.host.EPPHostDeleteCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.host.EPPHostPendActionMsg;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;

public class EPPHostMapFactory
extends EPPMapFactory {
    public static final String NS = "urn:ietf:params:xml:ns:host-1.0";
    public static final String NS_PREFIX = "host";
    private EPPService service = new EPPService("host", "urn:ietf:params:xml:ns:host-1.0");

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("host:check"))) {
            return new EPPHostCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("host:info"))) {
            return new EPPHostInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("host:create"))) {
            return new EPPHostCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("host:delete"))) {
            return new EPPHostDeleteCmd();
        }
        if (name.equals(EPPUtil.getLocalName("host:update"))) {
            return new EPPHostUpdateCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("host:chkData"))) {
            return new EPPHostCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("host:infData"))) {
            return new EPPHostInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("host:creData"))) {
            return new EPPHostCreateResp();
        }
        if (name.equals(EPPUtil.getLocalName("host:panData"))) {
            return new EPPHostPendActionMsg();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        theSchemas.add("host-1.0.xsd");
        return theSchemas;
    }
}

