/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostStatus;
import java.util.Date;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostInfoResp
extends EPPResponse {
    static final String ELM_NAME = "host:infData";
    static final String ELM_LINKED = "host:linked";
    static final String ELM_ROID = "host:roid";
    private static final String ELM_HOST_NAME = "host:name";
    private static final String ELM_CLIENT_ID = "host:clID";
    private static final String ELM_CREATED_BY = "host:crID";
    private static final String ELM_CREATED_DATE = "host:crDate";
    private static final String ELM_LAST_UPDATED_BY = "host:upID";
    private static final String ELM_LAST_UPDATED_DATE = "host:upDate";
    private static final String ELM_TRDATE = "host:trDate";
    private String name = null;
    private String clientId = null;
    private Vector addresses = new Vector();
    private String createdBy = null;
    private Date createdDate = null;
    private String lastUpdatedBy = null;
    private Date lastUpdatedDate = null;
    private Vector statuses = null;
    private Date trDate = null;
    private String roid = null;

    public EPPHostInfoResp() {
    }

    public EPPHostInfoResp(EPPTransId aTransId, String aName, String aRoid, EPPHostStatus aHostStatus, String aClientId, String aCreatedBy, Date aCreatedDate) {
        super(aTransId);
        this.name = aName;
        this.roid = aRoid;
        this.statuses = new Vector();
        this.statuses.addElement(aHostStatus);
        this.clientId = aClientId;
        this.createdBy = aCreatedBy;
        this.createdDate = aCreatedDate;
    }

    @Override
    public String getType() {
        return ELM_NAME;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("required attribute name is not set");
        }
        if (this.roid == null) {
            throw new EPPCodecException("required attribute roid is not set");
        }
        if (this.statuses == null) {
            throw new EPPCodecException("required attribute statuses is not set");
        }
        if (this.clientId == null) {
            throw new EPPCodecException("clientId required attribute is not set");
        }
        if (this.createdBy == null) {
            throw new EPPCodecException("createBy required attribute is not set");
        }
        if (this.createdDate == null) {
            throw new EPPCodecException("createdDate required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPHostInfoResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute("xmlns:host", "urn:ietf:params:xml:ns:host-1.0");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        EPPUtil.encodeString(aDocument, root, this.roid, "urn:ietf:params:xml:ns:host-1.0", ELM_ROID);
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        EPPUtil.encodeCompVector(aDocument, root, this.addresses);
        EPPUtil.encodeString(aDocument, root, this.clientId, "urn:ietf:params:xml:ns:host-1.0", ELM_CLIENT_ID);
        EPPUtil.encodeString(aDocument, root, this.createdBy, "urn:ietf:params:xml:ns:host-1.0", ELM_CREATED_BY);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createdDate, "urn:ietf:params:xml:ns:host-1.0", ELM_CREATED_DATE);
        if (this.lastUpdatedBy != null) {
            EPPUtil.encodeString(aDocument, root, this.lastUpdatedBy, "urn:ietf:params:xml:ns:host-1.0", ELM_LAST_UPDATED_BY);
        }
        if (this.lastUpdatedDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.lastUpdatedDate, "urn:ietf:params:xml:ns:host-1.0", ELM_LAST_UPDATED_DATE);
        }
        if (this.trDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.trDate, "urn:ietf:params:xml:ns:host-1.0", ELM_TRDATE);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        this.roid = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_ROID);
        this.statuses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:status", EPPHostStatus.class);
        this.addresses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:addr", EPPHostAddress.class);
        this.clientId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_CLIENT_ID);
        this.createdBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_CREATED_BY);
        this.createdDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_CREATED_DATE);
        this.lastUpdatedBy = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_LAST_UPDATED_BY);
        this.lastUpdatedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_LAST_UPDATED_DATE);
        this.trDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_TRDATE);
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostInfoResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPHostInfoResp theInfoData = (EPPHostInfoResp)aObject;
        if (!(this.name != null ? this.name.equals(theInfoData.name) : theInfoData.name == null)) {
            return false;
        }
        if (!(this.roid != null ? this.roid.equals(theInfoData.roid) : theInfoData.roid == null)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theInfoData.statuses)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.addresses, theInfoData.addresses)) {
            return false;
        }
        if (!(this.clientId != null ? this.clientId.equals(theInfoData.clientId) : theInfoData.clientId == null)) {
            return false;
        }
        if (!(this.createdBy != null ? this.createdBy.equals(theInfoData.createdBy) : theInfoData.createdBy == null)) {
            return false;
        }
        if (!(this.createdDate != null ? this.createdDate.equals(theInfoData.createdDate) : theInfoData.createdDate == null)) {
            return false;
        }
        if (!(this.lastUpdatedBy != null ? this.lastUpdatedBy.equals(theInfoData.lastUpdatedBy) : theInfoData.lastUpdatedBy == null)) {
            return false;
        }
        if (!(this.lastUpdatedDate != null ? this.lastUpdatedDate.equals(theInfoData.lastUpdatedDate) : theInfoData.lastUpdatedDate == null)) {
            return false;
        }
        return this.trDate != null ? this.trDate.equals(theInfoData.trDate) : theInfoData.trDate == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPHostInfoResp clone = (EPPHostInfoResp)super.clone();
        clone.addresses = (Vector)this.addresses.clone();
        for (i = 0; i < this.addresses.size(); ++i) {
            clone.addresses.setElementAt(((EPPHostAddress)this.addresses.elementAt(i)).clone(), i);
        }
        clone.statuses = (Vector)this.statuses.clone();
        for (i = 0; i < this.statuses.size(); ++i) {
            clone.statuses.setElementAt(((EPPHostStatus)this.statuses.elementAt(i)).clone(), i);
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String aClientId) {
        this.clientId = aClientId;
    }

    public Vector getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Vector someAddresses) {
        this.addresses = someAddresses;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String aCreatedBy) {
        this.createdBy = aCreatedBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date aDate) {
        this.createdDate = aDate;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public void setLastUpdatedBy(String aLastUpdatedBy) {
        this.lastUpdatedBy = aLastUpdatedBy;
    }

    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(Date aLastUpdatedDate) {
        this.lastUpdatedDate = aLastUpdatedDate;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public Date getTrDate() {
        return this.trDate;
    }

    public void setStatuses(EPPHostStatus aHostStatus) {
        if (this.statuses != null) {
            this.statuses.addElement(aHostStatus);
        } else {
            this.statuses = new Vector();
            this.statuses.addElement(aHostStatus);
        }
    }

    public void setStatuses(Vector newStatuses) {
        this.statuses = newStatuses;
    }

    public void setTrDate(Date newTrDate) {
        this.trDate = newTrDate;
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String newRoid) {
        this.roid = newRoid;
    }
}

