/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPExtFactory;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPLogoutCmd;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPPollCmd;
import com.verisign.epp.codec.gen.EPPProtocolExtension;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Element;

public class EPPFactory {
    private static EPPFactory instance = new EPPFactory();
    private static Logger cat = Logger.getLogger((String)EPPFactory.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private Hashtable factories = new Hashtable();
    private Hashtable extFactories = new Hashtable();
    private Set factoriesSet = new LinkedHashSet();
    private Set extFactoriesSet = new LinkedHashSet();

    protected EPPFactory() {
    }

    public static EPPFactory getInstance() {
        return instance;
    }

    public EPPCommand createCommand(String aCommandType, String aOp) throws EPPCodecException {
        String commandTypeLocalName = EPPUtil.getLocalName(aCommandType);
        if (commandTypeLocalName.equals(EPPUtil.getLocalName("login"))) {
            return new EPPLoginCmd();
        }
        if (commandTypeLocalName.equals(EPPUtil.getLocalName("logout"))) {
            return new EPPLogoutCmd();
        }
        if (commandTypeLocalName.equals(EPPUtil.getLocalName("poll"))) {
            return new EPPPollCmd();
        }
        throw new EPPCodecException("Invalid command type " + commandTypeLocalName + " in EPPFactory.createCommand");
    }

    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String nsUri = aMapElement.getNamespaceURI();
        EPPMapFactory target = (EPPMapFactory)this.factories.get(nsUri);
        if (target == null) {
            throw new EPPCodecException("Unable to find factory for namespace " + aMapElement.getNamespaceURI());
        }
        return target.createCommand(aMapElement);
    }

    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        EPPMapFactory target = (EPPMapFactory)this.factories.get(aMapElement.getNamespaceURI());
        if (target == null) {
            throw new EPPCodecException("Unable to find factory for namespace " + aMapElement.getNamespaceURI());
        }
        return target.createResponse(aMapElement);
    }

    public EPPCodecComponent createExtension(Element aExtensionElm) throws EPPCodecException {
        String nsUri = aExtensionElm.getNamespaceURI();
        EPPExtFactory target = (EPPExtFactory)this.extFactories.get(nsUri);
        if (target == null) {
            throw new EPPCodecException("Unable to find extension factory for namespace " + aExtensionElm.getNamespaceURI());
        }
        return target.createExtension(aExtensionElm);
    }

    public EPPProtocolExtension createProtocolExtension(Element aExtensionElm) throws EPPCodecException {
        String nsUri = aExtensionElm.getNamespaceURI();
        EPPExtFactory target = (EPPExtFactory)this.extFactories.get(nsUri);
        if (target == null) {
            throw new EPPCodecException("Unable to find extension factory for namespace " + aExtensionElm.getNamespaceURI());
        }
        return target.createProtocolExtension(aExtensionElm);
    }

    public Vector getServices() {
        Vector<EPPService> retServices = new Vector<EPPService>();
        Enumeration factoryElms = this.factories.elements();
        while (factoryElms.hasMoreElements()) {
            EPPMapFactory currFactory = (EPPMapFactory)factoryElms.nextElement();
            retServices.addElement(currFactory.getService());
        }
        return retServices;
    }

    public Vector getExtensions() {
        Vector<EPPService> retServices = new Vector<EPPService>();
        Enumeration factoryElms = this.extFactories.elements();
        while (factoryElms.hasMoreElements()) {
            EPPExtFactory currFactory = (EPPExtFactory)factoryElms.nextElement();
            retServices.addElement(currFactory.getService());
        }
        return retServices;
    }

    public boolean hasService(String aNamespace) {
        return this.factories.containsKey(aNamespace);
    }

    public boolean hasExtension(String aNamespace) {
        return this.extFactories.containsKey(aNamespace);
    }

    public void init(Vector someFactories) throws EPPCodecException {
        cat.debug((Object)"init(Vector): enter");
        Object currService = null;
        Object currFactory = null;
        String currFactoryName = null;
        this.factories = new Hashtable();
        for (int i = 0; i < someFactories.size(); ++i) {
            currFactoryName = (String)someFactories.elementAt(i);
            cat.debug((Object)("init(Vector): Add Map Factory <" + currFactoryName + ">"));
            this.addMapFactory(currFactoryName);
        }
        this.extFactories = new Hashtable();
        cat.debug((Object)"init(Vector): exit");
    }

    public void init(Vector someFactories, Vector someExtFactories) throws EPPCodecException {
        cat.debug((Object)"init(Vector, Vector): enter");
        this.init(someFactories);
        Object currService = null;
        Object currFactory = null;
        String currFactoryName = null;
        for (int i = 0; i < someExtFactories.size(); ++i) {
            currFactoryName = (String)someExtFactories.elementAt(i);
            cat.debug((Object)("init(Vector, Vector): Add Ext Factory <" + currFactoryName + ">"));
            this.addExtFactory(currFactoryName);
        }
        cat.debug((Object)"init(Vector, Vector): exit");
    }

    public void addMapFactory(String aMapFactory) throws EPPCodecException {
        cat.debug((Object)"addMapFactory(String): enter");
        try {
            if (!this.mapFactoryExists(aMapFactory)) {
                cat.info((Object)("addMapFactory(String): Loading <" + aMapFactory + ">"));
                Class<?> factoryClass = Class.forName(aMapFactory);
                if (!EPPMapFactory.class.isAssignableFrom(factoryClass)) {
                    throw new EPPCodecException(aMapFactory + " is not a subclass of EPPMapFactory");
                }
                EPPMapFactory theFactory = (EPPMapFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                EPPService theService = theFactory.getService();
                if (theService == null) {
                    throw new EPPCodecException(aMapFactory + " returned null on call to getService");
                }
                cat.info((Object)("addMapFactory(String): Adding <" + aMapFactory + "> with Namespace <" + theService.getNamespaceURI() + ">"));
                this.factories.put(theService.getNamespaceURI(), theFactory);
                this.factoriesSet.add(theFactory);
            }
        }
        catch (Exception e) {
            throw new EPPCodecException(aMapFactory + " " + e.getClass().getName() + ": " + e);
        }
        cat.debug((Object)"addMapFactory(String): exit");
    }

    public void addExtFactory(String aExtFactory) throws EPPCodecException {
        cat.debug((Object)"addExtFactory(String): enter");
        try {
            if (!this.extFactoryExists(aExtFactory)) {
                cat.info((Object)("addExtFactory(String): Loading <" + aExtFactory + ">"));
                Class<?> factoryClass = Class.forName(aExtFactory);
                if (!EPPExtFactory.class.isAssignableFrom(factoryClass)) {
                    throw new EPPCodecException(aExtFactory + " is not a subclass of EPPExtFactory");
                }
                EPPExtFactory theFactory = (EPPExtFactory)factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                EPPService theService = theFactory.getService();
                if (theService == null) {
                    throw new EPPCodecException(aExtFactory + " returned null on call to getService");
                }
                cat.info((Object)("addExtFactory(String): Adding <" + aExtFactory + "> with Namespace <" + theService.getNamespaceURI() + ">"));
                this.extFactories.put(theService.getNamespaceURI(), theFactory);
                this.extFactoriesSet.add(theFactory);
            }
        }
        catch (Exception e) {
            throw new EPPCodecException(aExtFactory + " " + e.getClass().getName() + ": " + e);
        }
        cat.debug((Object)"addExtFactory(String): exit");
    }

    public Set getXmlSchemas() {
        cat.debug((Object)"getXmlSchemas(): enter");
        LinkedHashSet<String> theSchemas = new LinkedHashSet<String>();
        cat.debug((Object)"getXmlSchemas(): Loading required EPP XML schemas");
        theSchemas.add("eppcom-1.0.xsd");
        theSchemas.add("epp-1.0.xsd");
        for (EPPMapFactory currFactory : this.factoriesSet) {
            cat.debug((Object)("getXmlSchemas(): Loading EPP XML schemas from " + currFactory.getClass().getName()));
            if (currFactory.getXmlSchemas() == null) continue;
            theSchemas.addAll(currFactory.getXmlSchemas());
        }
        for (EPPExtFactory currFactory : this.extFactoriesSet) {
            cat.debug((Object)("getXmlSchemas(): Loading EPP XML schemas from " + currFactory.getClass().getName()));
            if (currFactory.getXmlSchemas() == null) continue;
            theSchemas.addAll(currFactory.getXmlSchemas());
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("getXmlSchemas(): XML Schemas = " + theSchemas));
        }
        cat.debug((Object)"getXmlSchemas(): exit");
        return theSchemas;
    }

    boolean mapFactoryExists(String aMapFactory) {
        Enumeration enumeration = this.factories.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().getClass().getName().equals(aMapFactory)) continue;
            return true;
        }
        return false;
    }

    boolean extFactoryExists(String aExtFactory) {
        Enumeration enumeration = this.extFactories.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration.nextElement().getClass().getName().equals(aExtFactory)) continue;
            return true;
        }
        return false;
    }
}

