/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.fee.v23;

import com.verisign.epp.codec.fee.v23.EPPFeeCheckResult;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPFeeChkData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPFeeChkData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "chkData";
    public static final String ELM_NAME = "fee:chkData";
    private static final String ELM_CURRENCY = "currency";
    private String currency;
    private List<EPPFeeCheckResult> results = new ArrayList<EPPFeeCheckResult>();

    public EPPFeeChkData() {
    }

    public EPPFeeChkData(String aCurrency) {
        this.currency = aCurrency;
    }

    public EPPFeeChkData(String aCurrency, EPPFeeCheckResult aResult) {
        this.currency = aCurrency;
        this.addCheckResult(aResult);
    }

    public EPPFeeChkData(String aCurrency, List<EPPFeeCheckResult> aResults) {
        this.currency = aCurrency;
        this.setCheckResults(aResults);
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:fee-0.23";
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String aCurrency) {
        this.currency = aCurrency;
    }

    public List<EPPFeeCheckResult> getCheckResults() {
        return this.results;
    }

    public void setCheckResults(List<EPPFeeCheckResult> aResults) {
        this.results = aResults == null ? new ArrayList<EPPFeeCheckResult>() : aResults;
    }

    public void addCheckResult(EPPFeeCheckResult aResult) {
        this.results.add(aResult);
    }

    public void setCheckResult(EPPFeeCheckResult aResult) {
        this.results = new ArrayList<EPPFeeCheckResult>();
        this.results.add(aResult);
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPFeeChkData.encode(Document)");
        }
        if (this.currency == null) {
            throw new EPPEncodeException("currency is required in EPPFeeChkData.encode(Document)");
        }
        if (this.results == null || this.results.isEmpty()) {
            throw new EPPEncodeException("At least one result is required in EPPFeeChkData.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:fee-0.23", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.currency, "urn:ietf:params:xml:ns:fee-0.23", "fee:currency");
        EPPUtil.encodeCompList(aDocument, root, this.results);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.currency = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:fee-0.23", ELM_CURRENCY);
        this.results = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:fee-0.23", "fee:cd", EPPFeeCheckResult.class);
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPFeeChkData)) {
            cat.error((Object)"EPPFeeChkData.equals(): aObject is not an EPPFeeChkData");
            return false;
        }
        EPPFeeChkData other = (EPPFeeChkData)aObject;
        if (!EqualityUtil.equals(this.currency, other.currency)) {
            cat.error((Object)"EPPFeeChkData.equals(): currency not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.results, other.results)) {
            cat.error((Object)"EPPFeeChkData.equals(): results not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPFeeChkData clone = (EPPFeeChkData)super.clone();
        clone.currency = this.currency;
        clone.results = new ArrayList<EPPFeeCheckResult>();
        for (EPPFeeCheckResult result : this.results) {
            clone.results.add((EPPFeeCheckResult)result.clone());
        }
        return clone;
    }
}

