/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPEmailFwdAddRemove
implements EPPCodecComponent {
    static final short MODE_NONE = 0;
    static final short MODE_ADD = 1;
    static final short MODE_REMOVE = 2;
    static final String ELM_ADD = "emailFwd:add";
    static final String ELM_REMOVE = "emailFwd:rem";
    static final String ELM_CHANGE = "emailFwd:chg";
    static final short MODE_CHANGE = 3;
    private static final String ELM_CONTACT = "emailFwd:contact";
    private static final String ELM_STATUS = "emailFwd:status";
    private static final String ELM_REGISTRANT = "emailFwd:registrant";
    private static final String ELM_EMAILFWD_TO = "emailFwd:fwdTo";
    private short mode = 0;
    private Vector contacts = null;
    private Vector statuses = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;
    private String forwardTo = null;

    public EPPEmailFwdAddRemove() {
        this.contacts = null;
        this.statuses = null;
        this.registrant = null;
        this.forwardTo = null;
        this.authInfo = null;
    }

    public EPPEmailFwdAddRemove(Vector someContacts, Vector someStatuses) {
        this.contacts = someContacts;
        this.statuses = someStatuses;
    }

    public EPPEmailFwdAddRemove(String aRegistrant, String aForwardTo, EPPAuthInfo aAuthInfo) {
        this.registrant = aRegistrant;
        this.forwardTo = aForwardTo;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo");
    }

    public Vector getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector aContacts) {
        this.contacts = aContacts;
    }

    public Vector getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Vector aStatuses) {
        this.statuses = aStatuses;
    }

    public boolean contactsSupported() {
        return EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0");
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root;
        if (this.mode == 3) {
            Element root2 = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_CHANGE);
            if (this.forwardTo != null) {
                EPPUtil.encodeString(aDocument, root2, this.forwardTo, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_TO);
            }
            if (this.registrant != null) {
                EPPUtil.encodeString(aDocument, root2, this.registrant, "http://www.nic.name/epp/emailFwd-1.0", ELM_REGISTRANT);
            }
            if (this.authInfo != null) {
                EPPUtil.encodeComp(aDocument, root2, this.authInfo);
            }
            return root2;
        }
        if (this.mode == 1) {
            root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_ADD);
        } else if (this.mode == 2) {
            root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_REMOVE);
        } else {
            throw new EPPEncodeException("Invalid EPPEmailFwdAddRemove mode of " + this.mode);
        }
        if (this.contacts != null) {
            if (this.contactsSupported()) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        EPPUtil.encodeCompVector(aDocument, root, this.statuses);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_ADD))) {
            this.mode = 1;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_REMOVE))) {
            this.mode = (short)2;
        } else if (aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_CHANGE))) {
            this.mode = (short)3;
        } else {
            throw new EPPDecodeException("Invalid EPPEmailFwdAddRemove mode of " + aElement.getLocalName());
        }
        if (this.mode == 3) {
            this.forwardTo = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_TO);
            this.registrant = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_REGISTRANT);
            this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo", EPPAuthInfo.class);
        } else {
            this.contacts = EPPUtil.decodeCompVector(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_CONTACT, EPPEmailFwdContact.class);
            if (this.contacts.size() == 0) {
                this.contacts = null;
            }
            this.statuses = EPPUtil.decodeCompVector(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_STATUS, EPPEmailFwdStatus.class);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdAddRemove)) {
            return false;
        }
        EPPEmailFwdAddRemove theComp = (EPPEmailFwdAddRemove)aObject;
        if (this.mode != theComp.mode) {
            return false;
        }
        if (this.contactsSupported() && !EPPUtil.equalVectors(this.contacts, theComp.contacts)) {
            return false;
        }
        if (!EPPUtil.equalVectors(this.statuses, theComp.statuses)) {
            return false;
        }
        if (!(this.forwardTo != null ? this.forwardTo.equals(theComp.forwardTo) : theComp.forwardTo == null)) {
            return false;
        }
        if (!(this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdAddRemove clone = null;
        clone = (EPPEmailFwdAddRemove)super.clone();
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
            for (int i = 0; i < this.contacts.size(); ++i) {
                clone.contacts.setElementAt(((EPPEmailFwdContact)this.contacts.elementAt(i)).clone(), i);
            }
        }
        if (this.statuses != null) {
            clone.statuses = (Vector)this.statuses.clone();
        }
        if (this.forwardTo != null) {
            clone.forwardTo = this.forwardTo;
        }
        if (this.registrant != null) {
            clone.registrant = this.registrant;
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo");
        }
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    public void setForwardTo(String newForwardTo) {
        this.forwardTo = newForwardTo;
    }

    short getMode() {
        return this.mode;
    }

    void setMode(short aMode) {
        this.mode = aMode;
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/emailFwd-1.0";
    }
}

