/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPDomainInfoCmd
extends EPPInfoCmd {
    public static final String ELM_LOCALNAME = "info";
    public static final String ELM_NAME = "domain:info";
    public static final String HOSTS_ALL = "all";
    public static final String HOSTS_DELEGATED = "del";
    public static final String HOSTS_SUBORDINATE = "sub";
    public static final String HOSTS_NONE = "none";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ATTR_HOSTS = "hosts";
    private static Logger cat = Logger.getLogger((String)EPPDomainInfoCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String name;
    private String hosts = "all";
    private EPPAuthInfo authInfo = null;

    public EPPDomainInfoCmd() {
        this.name = null;
    }

    public EPPDomainInfoCmd(String aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    public EPPDomainInfoCmd(String aTransId, String aName, EPPAuthInfo aAuthInfo) {
        this(aTransId, aName);
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    public void setHosts(String aHost) {
        this.hosts = aHost;
    }

    public String getHosts() {
        return this.hosts;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("required attribute name is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", "domain:name");
        Text nameVal = aDocument.createTextNode(this.name);
        nameElm.appendChild(nameVal);
        root.appendChild(nameElm);
        if (this.hosts != null) {
            nameElm.setAttribute(ATTR_HOSTS, this.hosts);
        }
        if (this.authInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfo);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        if (currElm != null) {
            this.hosts = currElm.getAttribute(ATTR_HOSTS);
            if (this.hosts != null && this.hosts.length() == 0) {
                this.hosts = HOSTS_ALL;
            }
        }
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainInfoCmd)) {
            cat.error((Object)("EPPDomainInfoCmd.equals(): " + aObject.getClass().getName() + " not EPPDomainInfoCmd instance"));
            return false;
        }
        if (!super.equals(aObject)) {
            cat.error((Object)"EPPDomainInfoCmd.equals(): super class not equal");
            return false;
        }
        EPPDomainInfoCmd theComp = (EPPDomainInfoCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error((Object)"EPPDomainInfoCmd.equals(): name not equal");
            return false;
        }
        if (!(this.hosts != null ? this.hosts.equals(theComp.hosts) : theComp.hosts == null)) {
            cat.error((Object)"EPPDomainInfoCmd.equals(): hosts not equal");
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            cat.error((Object)"EPPDomainInfoCmd.equals(): authInfo not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainInfoCmd clone = (EPPDomainInfoCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

