/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainCheckCmd
extends EPPCheckCmd {
    public static final int MAX_DOMAINS = 99;
    public static final String ELM_LOCALNAME = "check";
    public static final String ELM_NAME = "domain:check";
    private static final String ELM_DOMAIN_NAME = "name";
    private Vector names;

    public EPPDomainCheckCmd() {
        this.names = new Vector();
    }

    public EPPDomainCheckCmd(String aTransId, String aName) {
        super(aTransId);
        this.names = new Vector();
        this.names.addElement(aName);
    }

    public EPPDomainCheckCmd(String aTransId, Vector someNames) {
        super(aTransId);
        this.names = someNames;
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainCheckCmd theMap = (EPPDomainCheckCmd)aObject;
        return EPPUtil.equalVectors(this.names, theMap.names);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDomainCheckCmd clone = (EPPDomainCheckCmd)super.clone();
        clone.names = (Vector)this.names.clone();
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public void setName(String aName) {
        this.names = new Vector();
        this.names.addElement(aName);
    }

    public Vector getNames() {
        return this.names;
    }

    public void setNames(Vector someNames) {
        this.names = someNames;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.names.size() == 0) {
            throw new EPPEncodeException("No domains names specified in EPPDomainCheckCmd");
        }
        if (this.names.size() > 99) {
            throw new EPPEncodeException(this.names.size() + " domain names is greater than the maximum of " + 99);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        EPPUtil.encodeVector(aDocument, root, this.names, "urn:ietf:params:xml:ns:domain-1.0", "domain:name");
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.names = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        if (this.names == null) {
            this.names = new Vector();
        }
    }
}

