/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.defReg.EPPDefRegPeriod;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPTransferCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDefRegTransferCmd
extends EPPTransferCmd {
    static final String ELM_NAME = "defReg:transfer";
    private static final String ELM_DEFREG_ROID = "defReg:roid";
    private static final String ELM_DEFREG_PERIOD = "defReg:period";
    private String roid = null;
    private EPPDefRegPeriod period = null;
    private EPPAuthInfo authInfo = null;

    public EPPDefRegTransferCmd() {
        this.roid = null;
        this.period = null;
        this.authInfo = null;
    }

    public EPPDefRegTransferCmd(String aTransId, String aOp, String aRoid) {
        super(aTransId, aOp);
        this.roid = aRoid;
        this.authInfo = null;
        this.period = null;
    }

    public EPPDefRegTransferCmd(String aTransId, String aOp, String aRoid, EPPAuthInfo aAuthInfo, EPPDefRegPeriod aPeriod) {
        super(aTransId, aOp);
        this.roid = aRoid;
        this.period = aPeriod;
        this.setAuthInfo(aAuthInfo);
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/defReg-1.0";
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/defReg-1.0", "defReg:authInfo");
        }
    }

    void validateState() throws EPPCodecException {
        if (super.getOp() == null) {
            throw new EPPCodecException("op required attribute is not set");
        }
        if (this.roid == null) {
            throw new EPPEncodeException("roid required attribute is not set");
        }
        if (super.getOp().equals("request") && this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPDefRegTransferCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", ELM_NAME);
        root.setAttribute("xmlns:defReg", "http://www.nic.name/epp/defReg-1.0");
        EPPUtil.encodeString(aDocument, root, this.roid, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_ROID);
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.roid = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_ROID);
        this.period = (EPPDefRegPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_PERIOD, EPPDefRegPeriod.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/defReg-1.0", "defReg:authInfo", EPPAuthInfo.class);
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    public EPPDefRegPeriod getPeriod() {
        return this.period;
    }

    public void setPeriod(EPPDefRegPeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDefRegTransferCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDefRegTransferCmd theMap = (EPPDefRegTransferCmd)aObject;
        if (!(this.roid != null ? this.roid.equals(theMap.roid) : theMap.roid == null)) {
            return false;
        }
        if (!(this.period != null ? this.period.equals(theMap.period) : theMap.period == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theMap.authInfo) : theMap.authInfo == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDefRegTransferCmd clone = (EPPDefRegTransferCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPDefRegPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }
}

