/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.defReg.EPPDefRegPeriod;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPRenewCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDefRegRenewCmd
extends EPPRenewCmd {
    static final String ELM_NAME = "defReg:renew";
    private static final String ELM_DEFREG_ROID = "defReg:roid";
    private static final String ELM_CURRENT_EXPIRATION_DATE = "defReg:curExpDate";
    private String roid = null;
    private EPPDefRegPeriod period = null;
    private Date curExpDate = null;

    public EPPDefRegRenewCmd() {
        this.roid = null;
        this.period = new EPPDefRegPeriod(1);
        this.curExpDate = null;
    }

    public EPPDefRegRenewCmd(String aTransId, String aRoid, Date aCurExpDate) {
        super(aTransId);
        this.roid = aRoid;
        this.curExpDate = aCurExpDate;
        this.period = new EPPDefRegPeriod(1);
    }

    public EPPDefRegRenewCmd(String aTransId, String aRoid, Date aCurExpDate, EPPDefRegPeriod aPeriod) {
        super(aTransId);
        this.roid = aRoid;
        this.curExpDate = aCurExpDate;
        this.period = aPeriod;
    }

    @Override
    public String getNamespace() {
        return "http://www.nic.name/epp/defReg-1.0";
    }

    public String getRoid() {
        return this.roid;
    }

    public void setRoid(String aRoid) {
        this.roid = aRoid;
    }

    @Override
    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDefRegRenewCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDefRegRenewCmd theMap = (EPPDefRegRenewCmd)aObject;
        if (!(this.roid != null ? this.roid.equals(theMap.roid) : theMap.roid == null)) {
            return false;
        }
        if (!(this.curExpDate != null ? this.curExpDate.equals(theMap.curExpDate) : theMap.curExpDate == null)) {
            return false;
        }
        return this.period != null ? this.period.equals(theMap.period) : theMap.period == null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPDefRegRenewCmd clone = (EPPDefRegRenewCmd)super.clone();
        if (this.period != null) {
            clone.period = (EPPDefRegPeriod)this.period.clone();
        }
        return clone;
    }

    @Override
    public String toString() {
        return EPPUtil.toString(this);
    }

    public Date getCurExpDate() {
        return this.curExpDate;
    }

    public EPPDefRegPeriod getPeriod() {
        return this.period;
    }

    public void setCurExpDate(Date newCurExpDate) {
        this.curExpDate = newCurExpDate;
    }

    public void setPeriod(EPPDefRegPeriod aPeriod) {
        this.period = aPeriod;
    }

    @Override
    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPDefRegRenewCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", ELM_NAME);
        root.setAttribute("xmlns:defReg", "http://www.nic.name/epp/defReg-1.0");
        EPPUtil.encodeString(aDocument, root, this.roid, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_ROID);
        EPPUtil.encodeDate(aDocument, root, this.curExpDate, "http://www.nic.name/epp/defReg-1.0", ELM_CURRENT_EXPIRATION_DATE);
        if (!this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        return root;
    }

    @Override
    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.roid = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_ROID);
        this.curExpDate = EPPUtil.decodeDate(aElement, "http://www.nic.name/epp/defReg-1.0", ELM_CURRENT_EXPIRATION_DATE);
        this.period = (EPPDefRegPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/defReg-1.0", "defReg:period", EPPDefRegPeriod.class);
    }

    void validateState() throws EPPCodecException {
        if (this.roid == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.curExpDate == null) {
            throw new EPPCodecException("currentExpirationYear required attribute is not set");
        }
    }
}

