/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactCheckCmd;
import com.verisign.epp.codec.contact.EPPContactCheckResp;
import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactCreateResp;
import com.verisign.epp.codec.contact.EPPContactDeleteCmd;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactPendActionMsg;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactTransferResp;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPMapFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Element;

public class EPPContactMapFactory
extends EPPMapFactory {
    private static Logger cat = Logger.getLogger((String)EPPContactMapFactory.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String NS = "urn:ietf:params:xml:ns:contact-1.0";
    public static final String NS_PREFIX = "contact";
    public static final String ELM_CONTACT_AUTHINFO = "contact:authInfo";
    private EPPService service = new EPPService("contact", "urn:ietf:params:xml:ns:contact-1.0");

    @Override
    public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("contact:check"))) {
            return new EPPContactCheckCmd();
        }
        if (name.equals(EPPUtil.getLocalName("contact:info"))) {
            return new EPPContactInfoCmd();
        }
        if (name.equals(EPPUtil.getLocalName("contact:create"))) {
            return new EPPContactCreateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("contact:delete"))) {
            return new EPPContactDeleteCmd();
        }
        if (name.equals(EPPUtil.getLocalName("contact:update"))) {
            return new EPPContactUpdateCmd();
        }
        if (name.equals(EPPUtil.getLocalName("contact:transfer"))) {
            return new EPPContactTransferCmd();
        }
        throw new EPPCodecException("Invalid command element " + name);
    }

    @Override
    public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
        String name = aMapElement.getLocalName();
        if (!aMapElement.getNamespaceURI().equals(NS)) {
            throw new EPPCodecException("Invalid mapping type " + name);
        }
        if (name.equals(EPPUtil.getLocalName("contact:chkData"))) {
            return new EPPContactCheckResp();
        }
        if (name.equals(EPPUtil.getLocalName("contact:infData"))) {
            return new EPPContactInfoResp();
        }
        if (name.equals(EPPUtil.getLocalName("contact:trnData"))) {
            return new EPPContactTransferResp();
        }
        if (name.equals(EPPUtil.getLocalName("contact:creData"))) {
            return new EPPContactCreateResp();
        }
        if (name.equals(EPPUtil.getLocalName("contact:panData"))) {
            return new EPPContactPendActionMsg();
        }
        throw new EPPCodecException("Invalid response element " + name);
    }

    @Override
    public EPPService getService() {
        return this.service;
    }

    @Override
    public Set getXmlSchemas() {
        HashSet<String> theSchemas = new HashSet<String>();
        if (EPPEnv.isContactRelaxedValidation()) {
            cat.debug((Object)"Adding relaxed contact schema contact-1.0-relaxed.xsd");
            theSchemas.add("contact-1.0-relaxed.xsd");
        } else {
            cat.debug((Object)"Adding strict contact schema contact-1.0.xsd");
            theSchemas.add("contact-1.0.xsd");
        }
        return theSchemas;
    }
}

