/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.balance;

import com.verisign.epp.codec.balance.EPPBalanceInfoCmd;
import com.verisign.epp.codec.balance.EPPBalanceInfoResp;
import com.verisign.epp.codec.balance.EPPCreditThreshold;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.util.TestThread;
import java.math.BigDecimal;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPBalanceTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPBalanceTst(String name) {
        super(name);
    }

    public void testBalanceInfoCmd() {
        EPPCodecTst.printStart("testBalanceInfoCmd");
        EPPBalanceInfoCmd cmd = new EPPBalanceInfoCmd();
        EPPCodecTst.testEncodeDecode(cmd);
        cmd = new EPPBalanceInfoCmd("ABC-12345");
        EPPCodecTst.testEncodeDecode(cmd);
        EPPCodecTst.printEnd("testBalanceInfoCmd");
    }

    public void testBalanceInfoResp() {
        EPPCodecTst.printStart("testBalanceInfoResp");
        EPPBalanceInfoResp resp = new EPPBalanceInfoResp(new EPPTransId("ABC-12345", "54322-XYZ"), new BigDecimal("1000.00"), new BigDecimal("200.00"), new BigDecimal("800.00"), new EPPCreditThreshold("FIXED", new BigDecimal("500.00")));
        EPPCodecTst.testEncodeDecode(resp);
        resp = new EPPBalanceInfoResp(new EPPTransId("ABC-12345", "54322-XYZ"), new BigDecimal("1000.00"), new BigDecimal("200.00"), new BigDecimal("800.00"), new EPPCreditThreshold("PERCENT", new BigDecimal("50")));
        EPPCodecTst.testEncodeDecode(resp);
        EPPCodecTst.printEnd("testBalanceInfoResp");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPBalanceTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.balance.EPPBalanceMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPBalanceMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPBalanceTst Thread " + i, EPPBalanceTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPBalanceTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

