/*
 * Decompiled with CFR 0.152.
 */
package com.codestudio.util;

import com.codestudio.util.LifeGuardThread;
import com.codestudio.util.Pool;
import com.codestudio.util.PoolMetaData;
import com.codestudio.util.PoolSkimmerThread;
import com.codestudio.util.PooledObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public abstract class ObjectPool
implements Pool {
    protected PoolMetaData metadata;
    protected int count;
    protected Hashtable locked;
    protected Hashtable unlocked;
    protected Thread skimmer;
    protected Thread lifeguard;
    protected Category logit;

    public ObjectPool(PoolMetaData poolMetaData) {
        this.metadata = poolMetaData;
        this.locked = new Hashtable(1);
        this.unlocked = new Hashtable(1);
        this.createLogger();
    }

    private void createLogger() {
        this.logit = Category.getInstance((String)this.metadata.getName());
        if (this.metadata.getLogFile() != null) {
            try {
                this.logit.addAppender((Appender)new DailyRollingFileAppender((Layout)new PatternLayout(), this.metadata.getLogFile(), "'.'yyyy-MM-dd"));
            }
            catch (IOException iOException) {
                System.out.println("Log file for " + this.metadata.getName() + " is invalid (" + this.metadata.getLogFile() + "): " + iOException);
                System.out.println("Logging that pool's info to the console");
                this.logit.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout()));
            }
        } else {
            System.out.println("No log file indicated for " + this.metadata.getName() + ", logging that pool's info to the console");
            this.logit.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout()));
        }
    }

    public void init() throws Exception {
        if (this.metadata.getInitialObjects() > 0) {
            this.debug("Creating " + this.metadata.getInitialObjects() + " initial objects in pool " + this.metadata.getName());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < this.metadata.getInitialObjects()) {
                arrayList.add(this.checkOut());
                ++n;
            }
            int n2 = 0;
            while (n2 < arrayList.size()) {
                this.checkIn(arrayList.get(n2));
                ++n2;
            }
            this.debug("Completed creation of initial objects");
        }
        this.debug("Starting PoolSkimmer, which will expire objects after the <skimmerFrequency> element (currently set to " + this.metadata.getSkimmerFrequency() + " seconds)");
        this.skimmer = new Thread(new PoolSkimmerThread(this.metadata.getSkimmerFrequency(), this));
        this.skimmer.setDaemon(true);
        this.skimmer.start();
        if (this.metadata.getUserTimeout() > 0) {
            this.debug("Starting LifeGuard, which will return checked-out objects to their pools if they are held longer than the <userTimeout> element (currently set to " + this.metadata.getUserTimeout() + " seconds)");
            this.lifeguard = new Thread(new LifeGuardThread(this.metadata.getUserTimeout(), this));
            this.lifeguard.setDaemon(true);
            this.lifeguard.start();
        } else {
            this.debug("Not starting LifeGuard, as the user timeout element is zero or less. Objects will NOT automatically return to their pools, and must be explicitly closed or returned.");
        }
    }

    protected abstract Object create() throws Exception;

    protected abstract boolean validate(Object var1);

    protected void expire(Object object) {
        if (object instanceof PooledObject) {
            ((PooledObject)object).closeAllResources();
        }
    }

    public String getPoolname() {
        return this.metadata.getName();
    }

    public Object requestObject() {
        try {
            return this.checkOut();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void returnObject(Object object) {
        this.checkIn(object);
    }

    public synchronized int numTotalObjects() {
        return this.count;
    }

    public synchronized int numCheckedOutObjects() {
        return this.locked.size();
    }

    public synchronized int numCheckedInObjects() {
        return this.unlocked.size();
    }

    protected synchronized Object checkOut() throws Exception {
        long l = System.currentTimeMillis();
        Object object = null;
        if (this.unlocked.size() > 0) {
            Enumeration enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (this.validate(object)) {
                    this.unlocked.remove(object);
                    this.locked.put(object, new Long(l));
                    break;
                }
                --this.count;
                this.unlocked.remove(object);
                this.expire(object);
                object = null;
            }
        }
        if (object != null) {
            this.debug("PoolMan ObjectPool: returned existing pooled object for request");
            this.debugMetrics();
            return object;
        }
        if (this.count < this.metadata.getMaximumSize()) {
            object = this.create();
            this.locked.put(object, new Long(l));
            ++this.count;
            this.debug("PoolMan ObjectPool: created a new object for request");
            this.debugMetrics();
            return object;
        }
        if (this.metadata.isMaximumSoft()) {
            this.debug("PoolMan ObjectPool: No available objects and maximum pool size soft limit reached... creating an emergency object that will be removed by automatic garbage collection");
            this.debugMetrics();
            object = this.create();
            this.locked.put(object, new Long(l));
            ++this.count;
            return object;
        }
        this.debug("PoolMan ObjectPool: No available objects and maximum pool size hard limit reached... waiting for an object to be checked in");
        this.wait(3000L);
        return this.checkOut();
    }

    protected synchronized void checkIn(Object object) {
        this.locked.remove(object);
        this.unlocked.put(object, new Long(System.currentTimeMillis()));
        if (!this.metadata.isMaximumSoft()) {
            this.notifyAll();
        }
        this.debug("PoolMan ObjectPool metrics after returning object:");
        this.debugMetrics();
    }

    public synchronized void updateLocked(PooledObject pooledObject) {
        if (this.locked.containsKey(pooledObject)) {
            this.locked.put(pooledObject, new Long(System.currentTimeMillis()));
        }
    }

    protected synchronized void cleanUp() {
        int n = this.metadata.getMinimumSize();
        if (this.unlocked.size() <= n) {
            return;
        }
        int n2 = this.metadata.getMaximumSize();
        int n3 = this.metadata.getShrinkBy();
        if (n3 < 1) {
            n3 = 5;
        }
        int n4 = 0;
        this.debug("PoolSkimmer cleaning objects from the pool that have exceeded their allotted lifespan, has " + this.unlocked.size() + " pooled objects to evaluate...");
        try {
            long l = System.currentTimeMillis();
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = this.unlocked.keys();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            int n5 = 0;
            while (n5 < arrayList.size()) {
                Object e = arrayList.get(n5);
                long l2 = (Long)this.unlocked.get(e);
                if (l - l2 > (long)(1000 * this.metadata.getObjectTimeout())) {
                    this.unlocked.remove(e);
                    this.expire(e);
                    --this.count;
                    ++n4;
                    e = null;
                    this.debug("PoolSkimmer: Removed and destroyed a pooled object from " + this.getPoolname());
                    this.debugMetrics();
                }
                if (this.unlocked.size() <= n) {
                    return;
                }
                if (n4 >= n3 && this.unlocked.size() + this.locked.size() <= n2) {
                    return;
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            this.log("PoolSkimmer unable to clean up available objects in the pool");
        }
        System.gc();
    }

    protected synchronized void checkTimeout() {
        long l = System.currentTimeMillis();
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = this.locked.keys();
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            int n = 0;
            while (n < arrayList.size()) {
                Object e = arrayList.get(n);
                long l2 = (Long)this.locked.get(e);
                if (System.currentTimeMillis() - l2 > (long)(1000 * this.metadata.getUserTimeout())) {
                    this.debug("LifeGuard returning an object to pool " + this.getPoolname() + " that had exceeded its user timeout");
                    if (e instanceof PooledObject) {
                        PooledObject pooledObject = (PooledObject)e;
                        pooledObject.clean();
                    }
                    this.locked.remove(e);
                    this.unlocked.put(e, new Long(System.currentTimeMillis()));
                    this.debugMetrics();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.debug("LifeGuard Unable to Evaluate Objects", exception);
        }
    }

    public synchronized void closeAllResources() {
        Object object;
        Enumeration enumeration = this.unlocked.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.expire(object);
            object = null;
        }
        object = this.locked.keys();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            this.expire(e);
            e = null;
        }
    }

    public void finalize() {
        this.closeAllResources();
    }

    public void log(String string) {
        this.logit.info((Object)string);
    }

    public void log(String string, Exception exception) {
        this.logit.error((Object)string, (Throwable)exception);
    }

    public void debug(String string) {
        if (this.metadata.isDebugging()) {
            this.logit.debug((Object)string);
        }
    }

    public void debug(String string, Exception exception) {
        if (this.metadata.isDebugging()) {
            this.logit.debug((Object)string, (Throwable)exception);
        }
    }

    protected void debugMetrics() {
        if (this.metadata.isDebugging()) {
            this.logit.debug((Object)("\tPool Name: " + this.metadata.getName() + " {" + " Total Objects: " + this.count + " Objects Available: " + this.unlocked.size() + " Objects In Use: " + this.locked.size() + " }"));
        }
    }
}

