/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.codec.registry.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.registry.v02.EPPRegistryPeriodType.Unit;

/**
 * The maximum supported period length
 */
public class EPPRegistryMaxPeriodType extends EPPRegistryPeriodType {

	/**
	 * XML local name for {@code EPPRegistryMaxPeriodType}.
	 */
	public static final String ELM_LOCALNAME = "max";
	

	/**
	 * Default constructor. Must call {@link #setNumber(Integer)} and
	 * {@link #setUnit(String)} before calling
	 * {@link #encode(org.w3c.dom.Document)} method.
	 */
	public EPPRegistryMaxPeriodType() {
	}

	/**
	 * Constructs an instance of {@code EPPRegistryMaxPeriodType} with
	 * {@code number} and {@code unit}.
	 *
	 * @param aNumber
	 *           number must be between 1 - 99.
	 * @param aUnit
	 *           unit must be one of {@link Unit#y} or {@link Unit#m}
	 */
	public EPPRegistryMaxPeriodType(Integer aNumber, Unit aUnit) {
		super(aNumber, aUnit);
	}
	
	/**
	 * Constructs an instance of {@code EPPRegistryMaxPeriodType} with
	 * {@code number} and {@code unit}.
	 *
	 * @param aNumber
	 *           number must be between 1 - 99.
	 * @param aUnit
	 *           unit must be one of {@link Unit#y} or {@link Unit#m}
	 */
	public EPPRegistryMaxPeriodType(int aNumber, Unit aUnit) {
		super(aNumber, aUnit);
	}

	
	/**
	 * Extra validation rules on top of
	 * {@link EPPRegistryPendingRestorePeriodType}: {@code number} must be
	 * between 1 - 99; {@code unit} must be one of {@link Unit#y} or
	 * {@link Unit#m}.
	 * 
	 * @throws EPPCodecException
	 *            Validation error
	 */
	void extraValidate() throws EPPCodecException {
		// Number
		int n = number.intValue();
		if (n < 1 || n > 99) {
			throw new EPPCodecException(getRootName()
					+ ": number should be between 1 - 99.");
		}
		
		// Unit
		if (super.unit != Unit.y && super.unit != Unit.m) {
			throw new EPPCodecException(getRootName()
					+ ": invalid unit. Valid values: y/m");
		}
	}
	
	/**
	 * Returns the XML namespace associated with the <code>EPPCodecComponent</code>.
	 * 
	 * @return XML namespace for the <code>EPPCodecComponent</code>. 
	 */
	@Override
	public String getNamespace() {
		return EPPRegistryMapFactory.NS;
	}

	/**
	 * Gets the root element local name.
	 *
	 * @return Root element local name.
	 */
	@Override
	protected String getRootName() {
		return ELM_LOCALNAME;
	}
	
}
