/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-0107  USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.codec.registry.v02;

import org.apache.log4j.Logger;

import com.verisign.epp.util.EPPCatFactory;

/**
 * Represents the minimum and maximum length of &lt;contact:name&gt; element
 * defined RFC 5733 using the &lt;registry:minLength&gt; and
 * &lt;registry:maxLength&gt; child elements, respectively.
 *
 * @see com.verisign.epp.codec.registry.v02.EPPRegistryPostal
 */
public class EPPRegistryContactName extends EPPRegistryAbstractMinMax {

	/**
	 * Logger
	 */
	private static Logger cat = Logger.getLogger(EPPRegistryContactName.class.getName(),
	      EPPCatFactory.getInstance().getFactory());

	/**
	 * XML local name for {@code EPPRegistryContactName}.
	 */
	public static final String ELM_LOCALNAME = "name";

	/**
	 * XML root tag for {@code EPPRegistryContactCity}.
	 */
	public static final String ELM_NAME = EPPRegistryMapFactory.NS_PREFIX + ":" + ELM_LOCALNAME;

	/**
	 * Creates a new {@code EPPRegistryContactName} object.
	 */
	public EPPRegistryContactName() {
	}

	/**
	 * Creates a new {@code EPPRegistryContactName} object that takes both the
	 * minimum and maximum values as {@code Integer}'s.
	 *
	 * @param aMin
	 *           Minimum value
	 * @param aMax
	 *           Maximum value
	 */
	public EPPRegistryContactName(Integer aMin, Integer aMax) {
		super(aMin, aMax);
	}

	/**
	 * Creates a new {@code EPPRegistryContactName} object that takes both the
	 * minimum and maximum values as {@code int}'s.
	 *
	 * @param aMin
	 *           Minimum value
	 * @param aMax
	 *           Maximum value
	 */
	public EPPRegistryContactName(int min, int max) {
		this(Integer.valueOf(min), Integer.valueOf(max));
	}

	/**
	 * Gets the root element local name.
	 *
	 * @return Root element local name.
	 */
	@Override
	protected String getRootName() {
		return ELM_LOCALNAME;
	}

	/**
	 * Gets the minimum element local name.
	 *
	 * @return Minimum element local name.
	 */
	@Override
	protected String getElmMin() {
		return ELM_MIN_LENGTH;
	}

	/**
	 * Gets the maximum element local name.
	 *
	 * @return Maximum element local name.
	 */
	@Override
	protected String getElmMax() {
		return ELM_MAX_LENGTH;
	}

	/**
	 * Gets the {@link Logger} to use.
	 *
	 * @return {@link Logger} instance to use for logging.
	 */
	@Override
	protected Logger getLogger() {
		return cat;
	}

}
