/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-0107  USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.codec.registry.v01;

import com.verisign.epp.codec.gen.EPPCodecException;

/**
 * Defines the length of time that the domain object will remain in the
 * pendingRestore status unless the restore report command is received.
 *
 * @see com.verisign.epp.codec.registry.v01.EPPRegistryRGP
 */
public class EPPRegistryPendingRestorePeriodType extends EPPRegistryPeriodType {

	/**
	 * XML local name for {@code EPPRegistryPendingRestorePeriodType}.
	 */
	public static final String ELM_LOCALNAME = "pendingRestore";

	/**
	 * Default constructor. Must call {@link #setNumber(Integer)} and
	 * {@link #setUnit(String)} before calling
	 * {@link #encode(org.w3c.dom.Document)} method.
	 */
	public EPPRegistryPendingRestorePeriodType() {
	}

	/**
	 * Constructs an instance of {@code EPPRegistryPendingRestorePeriodType} with
	 * {@code number} and {@code unit}.
	 *
	 * @param aNumber
	 *           number must be > 0
	 * @param aUnit
	 *           unit must be one of {@link Unit#y}, {@link Unit#m},
	 *           {@link Unit#d}, or {@link Unit#h}.
	 */
	public EPPRegistryPendingRestorePeriodType(Integer aNumber, Unit aUnit) {
		super(aNumber, aUnit);
	}

	/**
	 * Constructs an instance of {@code EPPRegistryPendingRestorePeriodType} with
	 * {@code number} and {@code unit}.
	 *
	 * @param aNumber
	 *           number must be > 0
	 * @param aUnit
	 *           unit must be one of {@link Unit#y}, {@link Unit#m},
	 *           {@link Unit#d}, or {@link Unit#h}
	 */
	public EPPRegistryPendingRestorePeriodType(int aNumber, Unit aUnit) {
		super(aNumber, aUnit);
	}

	/**
	 * Extra validation rules on top of
	 * {@link EPPRegistryPendingRestorePeriodType}: {@code number} must be
	 * greater than "0"; {@code unit} must be one of {@link Unit#y},
	 * {@link Unit#m}, {@link Unit#d}, or {@link Unit#h}.
	 * 
	 * @throws EPPCodecException
	 *            Validation error
	 */
	@Override
	void extraValidate() throws EPPCodecException {
		// Number
		int n = this.number.intValue();
		if (n <= 0) {
			throw new EPPCodecException(getRootName() + ": number should be greater than 0");
		}

		// Unit
		if (super.unit != Unit.y && super.unit != Unit.m && super.unit != Unit.d && super.unit != Unit.h) {
			throw new EPPCodecException(getRootName() + ": invalid unit. Valid values:  y/m/d/h");
		}
	}

	/**
	 * Returns the XML namespace associated with the
	 * <code>EPPCodecComponent</code>.
	 *
	 * @return XML namespace for the <code>EPPCodecComponent</code>.
	 */
	@Override
	public String getNamespace() {
		return EPPRegistryMapFactory.NS;
	}

	/**
	 * Gets the root element local name.
	 *
	 * @return Root element local name.
	 */
	@Override
	protected String getRootName() {
		return ELM_LOCALNAME;
	}

}
