/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.codec.registry.v01;

import org.apache.log4j.Logger;

import com.verisign.epp.util.EPPCatFactory;

/**
 * Defines the minimum and maximum number of subordinate host objects (child
 * hosts) for a domain object.
 */
public class EPPRegistryDomainHostLimit extends EPPRegistryAbstractMinMax {

	/**
	 * Logger
	 */
	private static Logger cat = Logger.getLogger(EPPRegistryDomainHostLimit.class.getName(),
	      EPPCatFactory.getInstance().getFactory());

	/**
	 * Constant for the {@code EPPRegistryDomainHostLimit} local name
	 */
	public static final String ELM_LOCALNAME = "childHost";

	/**
	 * Constant for the {@code EPPRegistryDomainHostLimit} (prefix and local
	 * name)
	 */
	public static final String ELM_NAME = EPPRegistryMapFactory.NS_PREFIX + ":" + ELM_LOCALNAME;

	/**
	 * Creates a new {@code EPPRegistryDomainHostLimit} object.
	 */
	public EPPRegistryDomainHostLimit() {
	}
	
	/**
	 * Creates a new {@code EPPRegistryDomainHostLimit} object that takes both the
	 * minimum and maximum values as {@code Integer}'s.
	 *
	 * @param aMin
	 *           Minimum value
	 * @param aMax
	 *           Maximum value
	 */
	public EPPRegistryDomainHostLimit(Integer aMin, Integer aMax) {
		super(aMin, aMax);
	}

	/**
	 * Creates a new {@code EPPRegistryDomainHostLimit} object that takes both the
	 * minimum and maximum values as {@code int}'s.
	 *
	 * @param aMin
	 *           Minimum value
	 * @param aMax
	 *           Maximum value
	 */
	public EPPRegistryDomainHostLimit(int min, int max) {
		this(Integer.valueOf(min), Integer.valueOf(max));
	}
	

	/**
	 * Gets the root element local name.
	 *
	 * @return Root element local name.
	 */
	@Override
	protected String getRootName() {
		return ELM_LOCALNAME;
	}

	/**
	 * Gets the minimum element local name.
	 *
	 * @return Minimum element local name.
	 */
	@Override
	protected String getElmMin() {
		return ELM_MIN;
	}

	/**
	 * Gets the maximum element local name.
	 *
	 * @return Maximum element local name.
	 */
	@Override
	protected String getElmMax() {
		return ELM_MAX;
	}

	/**
	 * Gets the {@link Logger} to use.
	 *
	 * @return {@link Logger} instance to use for logging.
	 */
	@Override
	protected Logger getLogger() {
		return cat;
	}
}
