/***********************************************************
Copyright (C) 2019 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ***********************************************************/
package com.verisign.epp.codec.loginsec.v03;

import java.security.InvalidParameterException;

/**
 * Event level, which include the following possible values:<br>
 * <ul>
 * <li><code>WARNING</code> - Event that needs to be addressed.</li>
 * <li><code>ERROR</code> - Event that needs to be addressed immediately.</li>
 * </ul>
 */
public enum EventLevel {
	WARNING("warning"), ERROR("error");

	private final String levelStr;

	/**
	 * Define the string value for the enumerated value.
	 * 
	 * @param aLevelStr
	 *           Enumerated value string
	 */
	EventLevel(String aLevelStr) {
		this.levelStr = aLevelStr;
	}

	/**
	 * Get the event level enumerated value given the matching string.
	 * 
	 * @param aString
	 *           <code>EventLevel</code> enumerated string to convert to an
	 *           enumerated <code>EventLevel</code> instance.
	 * 
	 * @return Enumerated <code>EventLevel</code> value matching the
	 *         <code>String</code>.
	 * 
	 * @throws InvalidParameterException
	 *            If <code>aString</code> does not match an enumerated
	 *            <code>EventLevel</code> string value.
	 */
	public static EventLevel getEventLevel(String aString) {
		if (aString.equals(WARNING.levelStr)) {
			return WARNING;
		}
		else if (aString.equals(ERROR.levelStr)) {
			return ERROR;
		}
		else {
			throw new InvalidParameterException("Event level value of " + aString + " is not valid.");
		}
	}

	/**
	 * Convert the enumerated <code>EventLevel</code> value to a
	 * <code>String</code>.
	 */
	public String toString() {
		return this.levelStr;
	}

}
