/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPLoginCmd;

/**
 * Interface that can be implemented and configured to be called by
 * {@link EPPSession} to customize the {@link EPPLoginCmd} prior to sending it.
 * Both the server's {@link EPPGreeting} and the original {@link EPPLoginCmd} is
 * provided. The adapter can modify the {@link EPPLoginCmd} that will then be
 * sent.
 */
public interface EPPLoginAdapter {

	/**
	 * Adapt the {@link EPPLoginCmd} <code>aLoginCmd</code> parameter based on
	 * the current state of the {@link EPPLoginCmd} and the contents of the
	 * {@link EPPGreeting} <code>aGreeting</code> parameter sent by the server.
	 * 
	 * @param aLoginCmd
	 *           Original {@link EPPLoginCmd} created by {@link EPPSession} that
	 *           can be adapted by the concrete <code>EPPLoginAdapter</code>.
	 * @param aGreeting
	 *           {@link EPPGreeting} returned by the server that can be used to
	 *           drive the adapting of the {@link EPPLoginCmd}.
	 * 
	 * @exception EPPCommandException
	 *               Error found with adapting the login
	 */
	void adaptLogin(EPPLoginCmd aLoginCmd, final EPPGreeting aGreeting) throws EPPCommandException;
}
