/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 ***********************************************************/

package com.verisign.epp.codec.allocationtoken;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.util.EPPCatFactory;

/**
 * Extension to the domain info command to the allocation token associated with
 * the domain name.
 */
public class EPPAllocationTokenInfo implements EPPCodecComponent {

	/**
	 * Log4j category for logging
	 */
	private static Logger cat = Logger.getLogger(EPPAllocationTokenInfo.class.getName(),
	      EPPCatFactory.getInstance().getFactory());

	/**
	 * Constant for the launch phase info extension local name
	 */
	public static final String ELM_LOCALNAME = "info";

	/**
	 * Constant for the launch phase info extension tag
	 */
	public static final String ELM_NAME = EPPAllocationTokenExtFactory.NS_PREFIX + ":" + ELM_LOCALNAME;

	/**
	 * Create an {@code EPPAllocationTokenInfo} instance
	 */
	public EPPAllocationTokenInfo() {
	}

	/**
	 * Encode the {@code EPPAllocationTokenInfo} to a DOM Element
	 * 
	 * @param aDocument
	 *           a DOM Document to attach data to.
	 * @return The root element of this component.
	 * 
	 * @throws EPPEncodeException
	 *            Thrown if any errors prevent encoding.
	 */
	public Element encode(Document aDocument) throws EPPEncodeException {

		Element root = aDocument.createElementNS(EPPAllocationTokenExtFactory.NS, ELM_NAME);

		return root;
	}

	/**
	 * Decode the DOM element to the {@code EPPAllocationTokenInfo}.
	 * 
	 * @param aElement
	 *           DOM Element to decode the attribute values
	 * @throws EPPDecodeException
	 *            Error decoding the DOM Element
	 */
	public void decode(Element aElement) throws EPPDecodeException {

	}

	/**
	 * implements a deep {@code EPPAllocationTokenInfo} compare.
	 * 
	 * @param aObject
	 *           {@code EPPAllocationTokenInfo} instance to compare with
	 * 
	 * @return true if equal false otherwise
	 */
	public boolean equals(Object aObject) {

		if (!(aObject instanceof EPPAllocationTokenInfo)) {
			cat.error("EPPAllocationTokenInfo.equals(): " + aObject.getClass().getName()
			      + " not EPPAllocationTokenInfo instance");

			return false;
		}

		return true;
	}

	/**
	 * Clone {@code EPPAllocationTokenInfo}.
	 * 
	 * @return clone of {@code EPPAllocationTokenInfo}
	 * @exception CloneNotSupportedException
	 *               standard Object.clone exception
	 */
	public Object clone() throws CloneNotSupportedException {

		EPPAllocationTokenInfo clone = (EPPAllocationTokenInfo) super.clone();
		return clone;
	}

	/**
	 * Returns the XML namespace associated with the {@code EPPCodecComponent}.
	 * 
	 * @return XML namespace for the {@code EPPCodecComponent}.
	 */
	@Override
	public String getNamespace() {
		return EPPAllocationTokenExtFactory.NS;
	}

}