/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.verisign.epp.util.EnvException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class Environment {
    protected static Properties properties = new Properties();

    public void envInitialize(String aConfigFile) throws EnvException {
        InputStream myPropStream = null;
        File myPropFile = new File(aConfigFile);
        if (myPropFile.exists()) {
            try {
                myPropStream = new FileInputStream(aConfigFile);
            }
            catch (FileNotFoundException ex) {
                throw new EnvException("Env : " + aConfigFile + " file not found " + ex.getMessage());
            }
            catch (SecurityException ex) {
                throw new EnvException("Env : " + aConfigFile + " Security manager prevented from Reading the Configuration file " + ex.getMessage());
            }
        } else {
            myPropStream = ClassLoader.getSystemResourceAsStream(aConfigFile);
            if (myPropStream == null) {
                myPropStream = Environment.class.getClassLoader().getResourceAsStream(aConfigFile);
            }
        }
        if (myPropStream == null) {
            throw new EnvException("Env : " + aConfigFile + " file could not be loaded");
        }
        properties = new Properties();
        try {
            properties.load(myPropStream);
        }
        catch (IOException ex) {
            throw new EnvException("Env : IO Problem is Encountered in reading " + aConfigFile + ex.getMessage());
        }
    }

    public void envInitialize(String aConfigFile, ClassLoader aClassLoader) throws EnvException {
        Object myPropStream = null;
        if (aClassLoader == null) {
            throw new EnvException(": ClassLoader parameter was null");
        }
        InputStream configIs = aClassLoader.getResourceAsStream("/" + aConfigFile);
        if (configIs == null) {
            throw new EnvException("Env : [" + aConfigFile + "] file could not be loaded with classloader [" + aClassLoader + "] not found in classpath\n");
        }
        properties = new Properties();
        try {
            properties.load(configIs);
        }
        catch (IOException ex) {
            throw new EnvException("Env : IO Problem is Encountered in reading " + aConfigFile + ex.getMessage());
        }
    }

    public static String getEnv(String aProperty) throws EnvException {
        String theValue = properties.getProperty(aProperty);
        if (theValue == null) {
            throw new EnvException("Unable to Extract Environmental variable " + aProperty);
        }
        return theValue.trim();
    }

    public static String getOption(String aProperty) {
        String theValue = properties.getProperty(aProperty);
        if (theValue != null) {
            return theValue.trim();
        }
        return theValue;
    }

    public static String getProperty(String aProperty) {
        return properties.getProperty(aProperty);
    }

    public static String getProperty(String aProperty, String aDefaultValue) {
        return properties.getProperty(aProperty, aDefaultValue);
    }

    public static void setProperties(Properties aProperties) {
        properties = aProperties;
    }

    public static void setProperty(String aProperty, String aValue) {
        if (aValue != null) {
            properties.setProperty(aProperty, aValue);
        } else {
            properties.remove(aProperty);
        }
    }
}

