/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport;

import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPConFactorySingle;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class EPPConFactoryTst {
    EPPClientCon myClient = null;

    public void handleIO(EPPClientCon myClientCon) throws EPPConException {
        PrintWriter out = null;
        BufferedReader in = null;
        out = new PrintWriter(myClientCon.getOutputStream(), true);
        in = new BufferedReader(new InputStreamReader(myClientCon.getInputStream()));
        try {
            String fromServer;
            while ((fromServer = in.readLine()) != null) {
                System.out.println("Server: " + fromServer);
                if (!fromServer.equals("Bye.")) {
                    out.println("Bye.");
                    System.out.println("Client: Bye.");
                    continue;
                }
                break;
            }
        }
        catch (IOException myException) {
            throw new EPPConException(myException.getMessage());
        }
        try {
            out.close();
            in.close();
        }
        catch (IOException myException) {
            throw new EPPConException(myException.getMessage());
        }
    }

    public static void main(String[] args) {
        EPPConFactoryTst myInstance = new EPPConFactoryTst();
        EPPConFactorySingle myCon = EPPConFactorySingle.getInstance();
        EPPEnvSingle env = EPPEnvSingle.getInstance();
        if (args.length == 0) {
            System.out.println("EPP Configuration File must be specified");
            System.exit(1);
        }
        try {
            env.initialize(args[0]);
        }
        catch (EPPEnvException e) {
            System.out.println("EPPEvnException is thrown :" + e.getMessage());
            return;
        }
        try {
            myInstance.myClient = myCon.getEPPConnection();
        }
        catch (EPPConException myException) {
            System.out.println("Exception : " + myException.getMessage());
            return;
        }
        try {
            myInstance.myClient.initialize();
        }
        catch (EPPConException myException) {
            System.out.println("get EPP Connection Exception when initiallizing : " + myException.getMessage());
            return;
        }
        try {
            myInstance.handleIO(myInstance.myClient);
        }
        catch (EPPConException myException) {
            System.out.println("EPP Connection Exception getting I/O Stream : " + myException.getMessage());
            return;
        }
        try {
            myInstance.myClient.close();
        }
        catch (EPPConException myException) {
            System.out.println("get EPP Connection Exception when Closing : " + myException.getMessage());
        }
    }
}

