/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.v03;

import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.loginsec.v03.EPPLoginSec;
import com.verisign.epp.codec.loginsec.v03.EPPLoginSecData;
import com.verisign.epp.codec.loginsec.v03.EPPLoginSecEvent;
import com.verisign.epp.codec.loginsec.v03.EventLevel;
import com.verisign.epp.codec.loginsec.v03.EventType;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.LoginSecSubGenHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPCatFactory;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class LoginSecV03GenHandler
implements LoginSecSubGenHandler {
    private static Logger cat = Logger.getLogger((String)LoginSecV03GenHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    public EPPEventResponse doLogin(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPLoginCmd theLoginCmd = (EPPLoginCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theLoginCmd.getTransId(), "54322-XYZ");
        EPPResponse theResponse = new EPPResponse(transId);
        EPPLoginSecData loginSecData = null;
        EPPLoginSecEvent theEvent = null;
        String thePassword = null;
        String theNewPassword = null;
        GregorianCalendar calendar = new GregorianCalendar();
        EPPLoginSec theExt = (EPPLoginSec)theLoginCmd.getExtension(EPPLoginSec.class);
        if (theExt != null && theLoginCmd.getPassword().equals("[LOGIN-SECURITY]") && theExt.hasPassword()) {
            thePassword = theExt.getPassword();
            cat.info((Object)("Authentication using EPPLoginSec extension password with length = " + thePassword.length()));
        } else {
            thePassword = theLoginCmd.getPassword();
            cat.info((Object)("Authentication using EPPLoginCmd password with length = " + thePassword.length()));
        }
        if (theLoginCmd.hasNewPassword()) {
            if (theExt != null && theLoginCmd.getNewPassword().equals("[LOGIN-SECURITY]") && theExt.hasNewPassword()) {
                theNewPassword = theExt.getNewPassword();
                cat.info((Object)("New password using EPPLoginSec extension with new password length = " + theNewPassword.length()));
            } else {
                theNewPassword = theLoginCmd.getNewPassword();
                cat.info((Object)("New password using EPPLoginCmd with length = " + theNewPassword.length()));
            }
        }
        if (theExt != null && theExt.hasUserAgent()) {
            cat.info((Object)("User agent = [" + theExt.getUserAgent() + "]"));
        } else {
            cat.info((Object)"No user agent passed");
        }
        switch (theLoginCmd.getClientId()) {
            case "test-expiring-pw": {
                theResponse.setResult(1000);
                sessionData.setLoggedIn(true);
                sessionData.setLoginCmd(theLoginCmd);
                loginSecData = new EPPLoginSecData();
                calendar = new GregorianCalendar();
                calendar.setTime(new Date(System.currentTimeMillis()));
                ((Calendar)calendar).add(6, 7);
                theEvent = new EPPLoginSecEvent(EventType.PASSWORD, EventLevel.WARNING, calendar.getTime(), "Password expiring in a week");
                loginSecData.addEvent(theEvent);
                theResponse.addExtension(loginSecData);
                break;
            }
            case "test-expired-pw": {
                theResponse.setResult(2200);
                loginSecData = new EPPLoginSecData();
                calendar = new GregorianCalendar();
                calendar.setTime(new Date(System.currentTimeMillis()));
                ((Calendar)calendar).add(6, -1);
                theEvent = new EPPLoginSecEvent(EventType.PASSWORD, EventLevel.ERROR, calendar.getTime(), "Password has expired");
                loginSecData.addEvent(theEvent);
                theResponse.addExtension(loginSecData);
                break;
            }
            case "test-all-events": {
                theResponse.setResult(1000);
                sessionData.setLoggedIn(true);
                sessionData.setLoginCmd(theLoginCmd);
                loginSecData = new EPPLoginSecData();
                calendar = new GregorianCalendar();
                calendar.setTime(new Date(System.currentTimeMillis()));
                ((Calendar)calendar).add(6, 7);
                theEvent = new EPPLoginSecEvent(EventType.PASSWORD, EventLevel.WARNING, calendar.getTime(), "Password expiring in a week");
                loginSecData.addEvent(theEvent);
                calendar = new GregorianCalendar();
                calendar.setTime(new Date(System.currentTimeMillis()));
                ((Calendar)calendar).add(6, 5);
                theEvent = new EPPLoginSecEvent(EventType.CERTIFICATE, EventLevel.WARNING, calendar.getTime(), null);
                loginSecData.addEvent(theEvent);
                theEvent = new EPPLoginSecEvent(EventType.CIPHER, EventLevel.WARNING, "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "Insecure cipher negotiated");
                loginSecData.addEvent(theEvent);
                theEvent = new EPPLoginSecEvent(EventType.TLS_PROTOCOL, EventLevel.WARNING, "SSLv3", "Insecure TLS protocol negotiated");
                loginSecData.addEvent(theEvent);
                theEvent = new EPPLoginSecEvent(EventType.NEW_PW, EventLevel.ERROR, "New password does not meet complexity requirements");
                loginSecData.addEvent(theEvent);
                theEvent = new EPPLoginSecEvent(EventType.STAT, "failedLogins", EventLevel.WARNING, "100", "P1D", "100 invalid logins over 1 day");
                loginSecData.addEvent(theEvent);
                theEvent = new EPPLoginSecEvent(EventType.CUSTOM, "myCustomEvent", EventLevel.WARNING, "A custom login security event occured");
                loginSecData.addEvent(theEvent);
                theResponse.addExtension(loginSecData);
                break;
            }
            default: {
                theResponse.setResult(1000);
                sessionData.setLoggedIn(true);
                sessionData.setLoginCmd(theLoginCmd);
            }
        }
        return new EPPEventResponse(theResponse);
    }
}

