/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCode;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPVerificationCode;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfData;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeInfo;
import com.verisign.epp.codec.verificationcode.EPPVerificationCodeProfile;
import com.verisign.epp.codec.verificationcode.TrustAnchorVerificationCodeValidator;
import com.verisign.epp.codec.verificationcode.VerificationCodeRevocationList;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.PKIXParameters;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class VerificationCodeDomainHandler
extends DomainHandler {
    private static Logger cat = Logger.getLogger((String)VerificationCodeDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private KeyStore trustStore;
    private PKIXParameters pkixParameters;
    private VerificationCodeRevocationList verificationCodeRevocationList = new VerificationCodeRevocationList();
    private TrustAnchorVerificationCodeValidator verificationCodeValidator;

    public VerificationCodeDomainHandler() {
        cat.debug((Object)"VerificationCodeDomainHandler.VerificationCodeDomainHandler(): enter");
        String truststore = Environment.getProperty("EPP.VerificationCode.truststore");
        if (truststore == null) {
            cat.error((Object)"VerificationCodeDomainHandler.VerificationCodeDomainHandler(): EPP.SignedCode.truststore NOT defined in configuration");
            System.err.println("VerificationCodeDomainHandler.VerificationCodeDomainHandler(): EPP.SignedCode.truststore NOT defined in configuration");
            System.exit(1);
        }
        cat.debug((Object)("VerificationCodeDomainHandler.VerificationCodeDomainHandler(): Signed Code Truststore = " + truststore));
        try {
            this.pkixParameters = this.loadPKIXParameters(truststore);
        }
        catch (Exception ex) {
            cat.error((Object)("VerificationCodeDomainHandler.VerificationCodeDomainHandler(): Error loading the public key: " + ex));
            ex.printStackTrace();
            System.exit(1);
        }
        this.verificationCodeValidator = new TrustAnchorVerificationCodeValidator(this.trustStore);
        String revocationListProp = Environment.getOption("EPP.VerificationCode.revocationList");
        if (revocationListProp == null) {
            File verificationCodeRevocationListFile = new File(revocationListProp);
            if (verificationCodeRevocationListFile.exists()) {
                try {
                    FileInputStream verificationCodeRevocationListStream = new FileInputStream(verificationCodeRevocationListFile);
                    this.verificationCodeRevocationList.decode(verificationCodeRevocationListStream);
                }
                catch (Exception ex) {
                    cat.error((Object)("VerificationCodeDomainHandler.VerificationCodeDomainHandler(): Error loading verification code revocation list : " + ex));
                    ex.printStackTrace();
                    System.exit(1);
                }
                cat.debug((Object)"VerificationCodeDomainHandler.VerificationCodeDomainHandler(): No verification code revocation list found");
            } else {
                cat.error((Object)("VerificationCodeDomainHandler.VerificationCodeDomainHandler(): Error finding verification code revocation list \"" + revocationListProp + "\""));
                System.exit(1);
            }
        } else {
            cat.debug((Object)"VerificationCodeDomainHandler.VerificationCodeDomainHandler(): EPP.VerificationCode.revocationList property NOT defined");
        }
        cat.debug((Object)"VerificationCodeDomainHandler.VerificationCodeDomainHandler(): exit");
    }

    private PKIXParameters loadPKIXParameters(String aTrustStoreName) throws Exception {
        this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        this.trustStore.load(trustStoreFile, null);
        PKIXParameters pkixParameters = new PKIXParameters(this.trustStore);
        pkixParameters.setRevocationEnabled(false);
        return pkixParameters;
    }

    private EPPEventResponse returnError(int aCode, String aClientTransId, String aReason) {
        cat.error((Object)("VerificationCodeDomainHandler.returnError: code = " + aCode + ", reason = " + aReason));
        EPPResponse theResponse = new EPPResponse();
        EPPResult theResult = new EPPResult(aCode);
        theResult.addExtValueReason(aReason);
        theResponse.setResult(theResult);
        theResponse.setTransId(new EPPTransId(aClientTransId, "54321-XYZ"));
        return new EPPEventResponse(theResponse);
    }

    private EPPEventResponse handleVerificationCode(String aMethod, EPPCommand aCommand) {
        cat.debug((Object)"VerificationCodeDomainHandler.handleVerificationCode: enter");
        if (aCommand.hasExtension(EPPEncodedSignedCode.class)) {
            EPPEncodedSignedCode theExt = (EPPEncodedSignedCode)aCommand.getExtension(EPPEncodedSignedCode.class);
            for (EPPEncodedSignedCodeValue signedCode : theExt.getSignedCodes()) {
                if (signedCode.validate(this.pkixParameters)) {
                    cat.debug((Object)("VerificationCodeDomainHandler." + aMethod + ": Signature is valid"));
                    try {
                        if (!this.verificationCodeValidator.validate(signedCode.getCode(), signedCode.getTrustAnchor())) {
                            cat.error((Object)("VerificationCodeDomainHandler." + aMethod + ": Code is NOT valid"));
                            cat.debug((Object)"VerificationCodeDomainHandler.handleVerificationCode: exit");
                            return this.returnError(2306, aCommand.getTransId(), "Code is invalid");
                        }
                        cat.debug((Object)("VerificationCodeDomainHandler." + aMethod + ": Code is valid"));
                    }
                    catch (EPPException e) {
                        cat.error((Object)("VerificationCodeDomainHandler." + aMethod + ": Exception validating the verification code: " + e));
                        cat.debug((Object)"VerificationCodeDomainHandler.handleVerificationCode: exit");
                        return this.returnError(2306, aCommand.getTransId(), "Error validating verification code");
                    }
                    if (signedCode.hasTrustAnchor()) {
                        try {
                            cat.debug((Object)("VerificationCodeDomainHandler." + aMethod + ": Matching Trust Anchor Alias = \"" + this.trustStore.getCertificateAlias(signedCode.getTrustAnchor().getTrustedCert()) + "\""));
                        }
                        catch (KeyStoreException e) {
                            cat.error((Object)("VerificationCodeDomainHandler." + aMethod + ": Error getting Trust Anchor Alias: " + e));
                        }
                    }
                } else {
                    cat.error((Object)("VerificationCodeDomainHandler." + aMethod + ": Signature is NOT valid"));
                    cat.debug((Object)"VerificationCodeDomainHandler.handleVerificationCode: exit");
                    return this.returnError(2306, aCommand.getTransId(), "Signed code signature invalid");
                }
                if (this.verificationCodeRevocationList.isRevoked(signedCode)) {
                    cat.error((Object)("VerificationCodeDomainHandler." + aMethod + ": signed code is revoked"));
                    cat.debug((Object)"VerificationCodeDomainHandler.handleVerificationCode: exit");
                    return this.returnError(2306, aCommand.getTransId(), "Signed code is revoked");
                }
                cat.debug((Object)("VerificationCodeDomainHandler." + aMethod + ": signed code is not revoked"));
                cat.info((Object)("VerificationCodeDomainHandler." + aMethod + ": verification code type = " + signedCode.getCodeType()));
                System.out.println("VerificationCodeDomainHandler." + aMethod + ": verification code type = " + signedCode.getCodeType());
                cat.info((Object)("VerificationCodeDomainHandler." + aMethod + ": verification code = " + signedCode.getCodeValue()));
                System.out.println("VerificationCodeDomainHandler." + aMethod + ": verification code = " + signedCode.getCodeValue());
            }
        } else {
            cat.info((Object)("VerificationCodeDomainHandler." + aMethod + ": verification code = null"));
            System.out.println("VerificationCodeDomainHandler." + aMethod + ": verification code = null");
        }
        cat.debug((Object)"VerificationCodeDomainHandler.handleVerificationCode: exit");
        return null;
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainInfo: enter");
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        if (!(theEventResponse.getResponse() instanceof EPPDomainInfoResp)) {
            cat.debug((Object)"VerificationCodeDomainHandler.doDomainInfo: return on error");
            return theEventResponse;
        }
        if (theCommand.hasExtension(EPPVerificationCodeInfo.class)) {
            EPPDomainInfoResp theResponse = (EPPDomainInfoResp)theEventResponse.getResponse();
            EPPVerificationCodeInfData theRespExt = null;
            EPPVerificationCodeInfo theCmdExt = (EPPVerificationCodeInfo)theCommand.getExtension(EPPVerificationCodeInfo.class);
            String profileName = "china";
            if (theCmdExt.hasProfile()) {
                profileName = theCmdExt.getProfile();
            }
            if (theCommand.getName().equalsIgnoreCase("domain1.example")) {
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.NOT_APPLICABLE);
            } else if (theCommand.getName().equalsIgnoreCase("domain2.example")) {
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, new EPPVerificationCodeProfile("china", EPPVerificationCodeProfile.Status.COMPLIANT));
            } else if (theCommand.getName().equalsIgnoreCase("domain3.example")) {
                EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.COMPLIANT);
                theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
            } else if (theCommand.getName().equalsIgnoreCase("domain4.example")) {
                EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.COMPLIANT);
                theProfile.addSetCode(new EPPVerificationCode(null, "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theProfile.addSetCode(new EPPVerificationCode(null, "real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
            } else if (theCommand.getName().equalsIgnoreCase("domain5.example")) {
                EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.NON_COMPLIANT);
                theProfile.addMissingCode(new EPPVerificationCode("domain", new GregorianCalendar(2015, 4, 3, 22, 0).getTime()));
                theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(2015, 4, 3, 22, 0).getTime()));
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.NON_COMPLIANT, theProfile);
                Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
                statuses.add(new EPPDomainStatus("serverHold"));
                theResponse.setStatuses(statuses);
            } else if (theCommand.getName().equalsIgnoreCase("domain6.example")) {
                EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.PENDING_COMPLIANCE);
                theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE, theProfile);
            } else if (theCommand.getName().equalsIgnoreCase("domain7.example")) {
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE);
                EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile("sample1", EPPVerificationCodeProfile.Status.PENDING_COMPLIANCE);
                theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt.addProfile(theProfile);
                theProfile = new EPPVerificationCodeProfile("sample2", EPPVerificationCodeProfile.Status.COMPLIANT);
                theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt.addProfile(theProfile);
            } else if (theCommand.getName().equalsIgnoreCase("domain8.example")) {
                EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.COMPLIANT);
                theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
                theProfile = new EPPVerificationCodeProfile("sample2", EPPVerificationCodeProfile.Status.NOT_APPLICABLE);
                theProfile.addSetCode(new EPPVerificationCode("2-abc555", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                theRespExt.addProfile(theProfile);
            } else if (theCommand.getName().startsWith("cvct")) {
                if (theCommand.getName().startsWith("cvct-transfer-noncompliant")) {
                    EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.PENDING_COMPLIANCE);
                    theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                    theProfile.addMissingCode(new EPPVerificationCode("real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                    theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE, theProfile);
                } else if (theCommand.getName().startsWith("cvct-delayed-real-name")) {
                    if (theCmdExt.hasProfile()) {
                        EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.COMPLIANT);
                        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new Date(System.currentTimeMillis())));
                        theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new Date(System.currentTimeMillis())));
                        theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
                    } else {
                        EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.PENDING_COMPLIANCE);
                        theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new Date(System.currentTimeMillis())));
                        theProfile.addMissingCode(new EPPVerificationCode("real-name", new Date(System.currentTimeMillis())));
                        theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.PENDING_COMPLIANCE, theProfile);
                    }
                } else {
                    EPPVerificationCodeProfile theProfile = new EPPVerificationCodeProfile(profileName, EPPVerificationCodeProfile.Status.COMPLIANT);
                    theProfile.addSetCode(new EPPVerificationCode("0-abc333", "domain", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                    theProfile.addSetCode(new EPPVerificationCode("0-abc444", "real-name", new GregorianCalendar(2015, 4, 3, 22, 0, 0).getTime()));
                    theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.COMPLIANT, theProfile);
                }
            } else {
                theRespExt = new EPPVerificationCodeInfData(EPPVerificationCodeInfData.Status.NOT_APPLICABLE);
            }
            if (theRespExt != null) {
                theResponse.addExtension(theRespExt);
            }
        } else {
            cat.debug((Object)"VerificationCodeDomainHandler.doDomainInfo: No EPPVerificationCodeInfo extension passed");
        }
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainInfo: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainCreate: enter");
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = this.handleVerificationCode("doDomainCreate", theCommand);
        if (theEventResponse == null) {
            theEventResponse = super.doDomainCreate(aEvent, aData);
        }
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainCreate: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainUpdate: enter");
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = this.handleVerificationCode("doDomainUpdate", theCommand);
        if (theEventResponse == null) {
            theEventResponse = super.doDomainUpdate(aEvent, aData);
        }
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainUpdate: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainRenew: enter");
        EPPDomainRenewCmd theCommand = (EPPDomainRenewCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = this.handleVerificationCode("doDomainRenew", theCommand);
        if (theEventResponse == null) {
            theEventResponse = super.doDomainRenew(aEvent, aData);
        }
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainRenew: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainDelete: enter");
        EPPDomainDeleteCmd theCommand = (EPPDomainDeleteCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = this.handleVerificationCode("doDomainDelete", theCommand);
        if (theEventResponse == null) {
            theEventResponse = super.doDomainDelete(aEvent, aData);
        }
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainDelete: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainTransfer: enter");
        EPPDomainTransferCmd theCommand = (EPPDomainTransferCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = this.handleVerificationCode("doDomainTransfer", theCommand);
        if (theEventResponse == null) {
            theEventResponse = super.doDomainTransfer(aEvent, aData);
        }
        cat.debug((Object)"VerificationCodeDomainHandler.doDomainTransfer: exit");
        return theEventResponse;
    }
}

