/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.framework.EPPAssembler;
import com.verisign.epp.framework.EPPDispatcher;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.framework.EPPXMLAssembler;
import com.verisign.epp.serverstub.ClientConnectionHandler;
import com.verisign.epp.serverstub.ConnectionHandler;
import com.verisign.epp.serverstub.PollDataSource;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPServerCon;
import com.verisign.epp.transport.EPPSrvFactorySingle;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import com.verisign.epp.util.EPPEnvSingle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.xml.DOMConfigurator;

public class Server {
    public static final int WK_PORT = 2015;
    private static final Logger cat = Logger.getLogger((String)Server.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private int connection_count = 0;
    private int port;

    public Server(String configFileName) {
        try {
            EPPEnvSingle env = EPPEnvSingle.getInstance();
            env.initialize(configFileName);
            this.initializeLogging();
            EPPSrvFactorySingle theFactory = EPPSrvFactorySingle.getInstance();
            this.initializeDispatcher();
            EPPPollQueueMgr.getInstance().setDataSource(new PollDataSource());
            this.initializePollQueue();
            cat.info((Object)"EPP Server: Starting server...");
            cat.info((Object)"EPP Server: Creating server socket...");
            EPPServerCon theServer = theFactory.getEPPServer();
            theServer.RunServer(new ClientConnectionHandler());
        }
        catch (EPPConException e) {
            cat.error((Object)("EPP Server: Connection Exception: " + e));
            e.printStackTrace();
            System.exit(1);
        }
        catch (EPPEnvException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void initializeLogging() {
        try {
            switch (EPPEnv.getLogMode()) {
                case 0: {
                    Logger root = Logger.getRootLogger();
                    root.setLevel(EPPEnv.getLogLevel());
                    root.addAppender((Appender)new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), EPPEnv.getLogFile(), true));
                    break;
                }
                case 1: {
                    Long logCfgFileWatch;
                    boolean theLoadedFromClassPath;
                    String theLogCfgFileProp = EPPEnv.getLogCfgFile();
                    File theLogCfgFile = new File(theLogCfgFileProp);
                    URL theLogCfgFileURL = null;
                    if (theLogCfgFile.exists()) {
                        theLoadedFromClassPath = false;
                        theLogCfgFileURL = new URL("file:" + theLogCfgFileProp);
                        System.out.println("Server.initializeLogging: Loading log configuration file <" + theLogCfgFileProp + "> from file system");
                    } else {
                        theLoadedFromClassPath = true;
                        theLogCfgFileURL = ClassLoader.getSystemResource(theLogCfgFileProp);
                        if (theLogCfgFileURL == null) {
                            theLogCfgFileURL = Server.class.getClassLoader().getResource(theLogCfgFileProp);
                            System.out.println("Server.initializeLogging: Loading log configuration file <" + theLogCfgFileProp + "> from Server ClassLoader");
                        } else {
                            System.out.println("Server.initializeLogging: Loading log configuration file <" + theLogCfgFileProp + "> from system ClassLoader");
                        }
                    }
                    if (theLogCfgFileURL == null) {
                        System.err.println("Server.initializeLogging: Unable to find configuration file :" + theLogCfgFileProp);
                        System.exit(1);
                    }
                    DOMConfigurator.configure((URL)theLogCfgFileURL);
                    if (!theLoadedFromClassPath && (logCfgFileWatch = EPPEnv.getLogCfgFileWatch()) != null) {
                        DOMConfigurator.configureAndWatch((String)theLogCfgFileProp, (long)logCfgFileWatch);
                        System.out.println("Server.initializeLogging: Added watch of log configuration file <" + theLogCfgFileProp + "> every " + logCfgFileWatch + " ms");
                    }
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    System.err.println("Server.initializeLogging(): Invalid log mode of :" + EPPEnv.getLogMode());
                    System.exit(1);
                }
            }
        }
        catch (EPPEnvException e) {
            System.err.println("Server.initializeLogging():  When initializing Log " + e);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Server.initializeLogging():  When initializing Log " + e);
            System.exit(1);
        }
    }

    public void initializePollQueue() {
        EPPPollQueueMgr thePollQueue = EPPPollQueueMgr.getInstance();
        try {
            Vector handlerClasses = EPPEnv.getPollHandlers();
            if (handlerClasses != null) {
                Enumeration e = handlerClasses.elements();
                while (e.hasMoreElements()) {
                    String handlerClassName = (String)e.nextElement();
                    Class<?> handlerClass = Class.forName(handlerClassName);
                    thePollQueue.register((EPPPollHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    cat.info((Object)("Successfully loaded poll handler: " + handlerClass.getName()));
                }
            }
        }
        catch (EPPEnvException e) {
            cat.error((Object)"Couldn't initialize the environment", (Throwable)e);
            System.exit(1);
        }
        catch (InstantiationException e) {
            cat.error((Object)"Couldn't instantiate one of the specified server poll handlers", (Throwable)e);
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            cat.error((Object)"Couldn't instantiate one of the specified server poll handlers\n The class or initializer is not accessible", (Throwable)e);
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            cat.error((Object)"Couldn't instantiate one of the poll handlers listed in the conf file", (Throwable)e);
            System.exit(1);
        }
        catch (Exception e) {
            cat.error((Object)"General exception in initializePollQueue:", (Throwable)e);
            System.exit(1);
        }
    }

    public void initializeDispatcher() {
        EPPDispatcher theDispatcher;
        block21: {
            theDispatcher = EPPDispatcher.getInstance();
            try {
                Vector mapFactories;
                Vector handlerClasses = EPPEnv.getServerEventHandlers();
                Enumeration e = handlerClasses.elements();
                while (e.hasMoreElements()) {
                    String handlerClassName = (String)e.nextElement();
                    Class<?> handlerClass = Class.forName(handlerClassName);
                    theDispatcher.registerHandler((EPPEventHandler)handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    cat.info((Object)("Successfully loaded server handler: " + handlerClass.getName()));
                }
                EPPFactory factory = EPPFactory.getInstance();
                Vector commandExts = EPPEnv.getCmdResponseExtensions();
                if (commandExts != null && commandExts.elements().hasMoreElements()) {
                    for (int i = 0; i < commandExts.size(); ++i) {
                        String commandExtensionClassName = (String)commandExts.elementAt(i);
                        try {
                            factory.addExtFactory(commandExtensionClassName);
                        }
                        catch (EPPCodecException ex) {
                            cat.error((Object)("Couldn't load the Extension Factoryassociated with the CommandResponseExtensions" + ex));
                            System.exit(1);
                        }
                        cat.info((Object)("Successfully loaded Command Extension Class:" + commandExtensionClassName));
                    }
                }
                if ((mapFactories = EPPEnv.getMapFactories()) == null || !mapFactories.elements().hasMoreElements()) break block21;
                for (int i = 0; i < mapFactories.size(); ++i) {
                    String mapFactoryClassName = (String)mapFactories.elementAt(i);
                    try {
                        factory.addMapFactory(mapFactoryClassName);
                    }
                    catch (EPPCodecException ex) {
                        cat.error((Object)("Couldn't load the Map Factory " + mapFactoryClassName + ":" + ex));
                        System.exit(1);
                    }
                    cat.info((Object)("Successfully loaded Map Factory Class:" + mapFactoryClassName));
                }
            }
            catch (EPPEnvException e) {
                cat.error((Object)"Couldn't initialize the environment", (Throwable)e);
                System.exit(1);
            }
            catch (InstantiationException e) {
                cat.error((Object)"Couldn't instantiate one of the specified server event handlers:", (Throwable)e);
                System.exit(1);
            }
            catch (IllegalAccessException e) {
                cat.error((Object)"Couldn't instantiate one of the specified server event handlers\n The class or initializer is not accessible:", (Throwable)e);
                System.exit(1);
            }
            catch (ClassNotFoundException e) {
                cat.error((Object)"Couldn't instantiate one of the event handlers listed in the conf file:", (Throwable)e);
                System.exit(1);
            }
            catch (Exception e) {
                cat.error((Object)"General exception in initializeDispatcher: ", (Throwable)e);
                System.exit(1);
            }
        }
        try {
            String assemblerClassName = EPPEnv.getServerEPPAssembler();
            if (assemblerClassName != null && assemblerClassName.length() > 0) {
                cat.info((Object)("Found Assembler class in config: [" + assemblerClassName + "]"));
                cat.info((Object)("Attempting to instantiate " + assemblerClassName + "..."));
                Class<?> assemblerClass = Class.forName(assemblerClassName);
                EPPAssembler assembler = (EPPAssembler)assemblerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                theDispatcher.setAssembler(assembler);
                cat.info((Object)("Successfully set assembler " + assemblerClassName));
            } else {
                cat.info((Object)"No EPPServerAssembler specified. Using default... (com.verisign.epp.framework.EPPXMLAssembler)");
                theDispatcher.setAssembler(new EPPXMLAssembler());
            }
        }
        catch (InstantiationException e) {
            cat.error((Object)"Couldn't instantiate the specified Server Assembler class. Check class name \n and environment CLASSPATH:", (Throwable)e);
            System.exit(1);
        }
        catch (IllegalAccessException e) {
            cat.error((Object)"Couldn't instantiate the specified Server Assembler class. Check class name\n and CLASSPATH envrionment variable. The class or initializer is not accessible:", (Throwable)e);
            System.exit(1);
        }
        catch (ClassNotFoundException e) {
            cat.error((Object)"Couldn't instantiate the specified Server Assembler class. Check class name \n and environment CLASSPATH:", (Throwable)e);
            System.exit(1);
        }
        catch (Exception e) {
            cat.error((Object)"General exception in initializeDispatcher: ", (Throwable)e);
            System.exit(1);
        }
        theDispatcher.registerConnectionHandler(new ConnectionHandler());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java Server <config-file>");
            System.exit(1);
        }
        Server svr = new Server(args[0]);
    }
}

