/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAvailable;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreateResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDelete;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDeleteResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomainData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtField;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtFields;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtGroup;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfData;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtName;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRegistered;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenew;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtRenewResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransferResp;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtUpdate;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class RelatedDomainHandler
extends DomainHandler {
    private static final String svrTransId = "54322-XYZ";
    private static Logger cat = Logger.getLogger((String)RelatedDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theMessage = (EPPDomainCreateCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtCreate.class)) {
            return super.doDomainCreate(aEvent, aData);
        }
        EPPRelatedDomainExtCreate relDomCreate = (EPPRelatedDomainExtCreate)theMessage.getExtension(EPPRelatedDomainExtCreate.class);
        cat.info((Object)("Domain Create has relatedDomain extension for domain = " + theMessage.getName()));
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPDomainCreateResp theResponse = new EPPDomainCreateResp(respTransId, theMessage.getName(), theDate, expDate);
        theResponse.setResult(1000);
        if (relDomCreate.hasDomains()) {
            EPPRelatedDomainExtCreateResp resp = new EPPRelatedDomainExtCreateResp();
            for (EPPRelatedDomainExtDomain domain : relDomCreate.getDomains()) {
                resp.addDomain(new EPPRelatedDomainExtDomainData(domain.getName(), theDate, expDate));
            }
            theResponse.addExtension(resp);
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theMessage = (EPPDomainDeleteCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtDelete.class)) {
            return super.doDomainDelete(aEvent, aData);
        }
        EPPRelatedDomainExtDelete relDomDelete = (EPPRelatedDomainExtDelete)theMessage.getExtension(EPPRelatedDomainExtDelete.class);
        cat.info((Object)("Domain Delete has relatedDomain extension for domain = " + theMessage.getName()));
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1001);
        if (relDomDelete.hasDomains()) {
            EPPRelatedDomainExtDeleteResp resp = new EPPRelatedDomainExtDeleteResp();
            boolean isDeleted = true;
            for (String domain : relDomDelete.getDomains()) {
                resp.addDomain(new EPPRelatedDomainExtDomainData(domain, isDeleted ? "deleted" : "pendingDelete"));
                isDeleted = !isDeleted;
            }
            theResponse.addExtension(resp);
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theMessage = (EPPDomainRenewCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtRenew.class)) {
            return super.doDomainRenew(aEvent, aData);
        }
        EPPRelatedDomainExtRenew relDomRenew = (EPPRelatedDomainExtRenew)theMessage.getExtension(EPPRelatedDomainExtRenew.class);
        cat.info((Object)("Domain Renew has relatedDomain extension for domain = " + theMessage.getName()));
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getFiveYearsFutureDate();
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        EPPDomainRenewResp theResponse = new EPPDomainRenewResp(respTransId, "example.com", expDate);
        theResponse.setResult(1000);
        if (relDomRenew.hasDomains()) {
            EPPRelatedDomainExtRenewResp resp = new EPPRelatedDomainExtRenewResp();
            for (EPPRelatedDomainExtDomain domain : relDomRenew.getDomains()) {
                resp.addDomain(new EPPRelatedDomainExtDomainData(domain.getName(), expDate));
            }
            theResponse.addExtension(resp);
        }
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theMessage = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtUpdate.class)) {
            return super.doDomainUpdate(aEvent, aData);
        }
        cat.info((Object)("Domain Update has relatedDomain extension for domain = " + theMessage.getName()));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theMessage = (EPPDomainTransferCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtTransfer.class)) {
            return super.doDomainTransfer(aEvent, aData);
        }
        EPPRelatedDomainExtTransfer relDomTransfer = (EPPRelatedDomainExtTransfer)theMessage.getExtension(EPPRelatedDomainExtTransfer.class);
        cat.info((Object)("Domain Transfer has relatedDomain extension for domain = " + theMessage.getName()));
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPDomainTransferResp theResponse = this.getEPPDomainTransferResp(theMessage.getName(), theMessage.getOp());
        theResponse.setResult(1000);
        if (relDomTransfer.hasDomains()) {
            EPPRelatedDomainExtTransferResp resp = new EPPRelatedDomainExtTransferResp();
            for (EPPRelatedDomainExtDomain domain : relDomTransfer.getDomains()) {
                resp.addDomain(this.getDomainDataForTransferResp(domain.getName(), theMessage.getOp()));
            }
            theResponse.addExtension(resp);
        }
        if (!theMessage.getOp().equals("query")) {
            EPPDomainTransferResp thePollMsg = this.getEPPDomainTransferResp(theMessage.getName(), theMessage.getOp());
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
                if (relDomTransfer.hasDomains()) {
                    for (EPPRelatedDomainExtDomain domain : relDomTransfer.getDomains()) {
                        thePollMsg = this.getEPPDomainTransferResp(domain.getName(), theMessage.getOp());
                    }
                    EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", thePollMsg, null);
                }
            }
            catch (EPPPollQueueException ex) {
                cat.error((Object)("doDomainTransfer: Error putting message [" + thePollMsg + "]"));
                EPPResult theResult = new EPPResult(2400);
                EPPResponse failureResponse = new EPPResponse(transId, theResult);
                return new EPPEventResponse(failureResponse);
            }
        }
        return new EPPEventResponse(theResponse);
    }

    private EPPDomainTransferResp getEPPDomainTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        EPPDomainTransferResp theResponse = new EPPDomainTransferResp(respTransId, aDomainName);
        theResponse.setResult(1000);
        theResponse.setRequestClient("ClientX");
        theResponse.setActionClient("ClientY");
        theResponse.setTransferStatus(this.getTransferStatus(aCommandType));
        theResponse.setRequestDate(theDate);
        theResponse.setActionDate(theDate);
        theResponse.setExpirationDate(expDate);
        return theResponse;
    }

    private EPPRelatedDomainExtDomainData getDomainDataForTransferResp(String aDomainName, String aCommandType) {
        Date theDate = this.getTodaysUTCDateAtMidnight();
        Date expDate = this.getOneYearFutureDate();
        EPPRelatedDomainExtDomainData result = new EPPRelatedDomainExtDomainData();
        result.setName(aDomainName);
        result.setRequestClient("ClientX");
        result.setActionClient("ClientY");
        result.setTransferStatus(this.getTransferStatus(aCommandType));
        result.setRequestDate(theDate);
        result.setActionDate(theDate);
        result.setExpirationDate(expDate);
        return result;
    }

    private String getTransferStatus(String aCommandType) {
        if (aCommandType.equals("request") || aCommandType.equals("query")) {
            return "pending";
        }
        if (aCommandType.equals("cancel")) {
            return "clientCancelled";
        }
        if (aCommandType.equals("reject")) {
            return "clientRejected";
        }
        if (aCommandType.equals("approve")) {
            return "clientApproved";
        }
        return "pending";
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPResponse theResponse;
        EPPDomainInfoCmd theMessage = (EPPDomainInfoCmd)aEvent.getMessage();
        if (!theMessage.hasExtension(EPPRelatedDomainExtInfo.class)) {
            return super.doDomainInfo(aEvent, aData);
        }
        cat.info((Object)"Domain Info has relatedDomain extension");
        EPPRelatedDomainExtInfo cmdExt = (EPPRelatedDomainExtInfo)theMessage.getExtension(EPPRelatedDomainExtInfo.class);
        EPPTransId respTransId = new EPPTransId(theMessage.getTransId(), "54321-XYZ");
        if (cmdExt.getType().equals(EPPRelatedDomainExtInfo.TYPE_DOMAIN)) {
            Vector<EPPDomainStatus> statuses = new Vector<EPPDomainStatus>();
            statuses.addElement(new EPPDomainStatus("ok"));
            theResponse = new EPPDomainInfoResp(respTransId, "EXAMPLE1-VRSN", theMessage.getName(), "ClientX", statuses, "ClientY", new Date(), new EPPAuthInfo("2fooBAR"));
            EPPDomainInfoResp theDomainInfoResp = (EPPDomainInfoResp)theResponse;
            theDomainInfoResp.setResult(1000);
            theDomainInfoResp.setRegistrant("sh0813");
            EPPDomainContact contactAdmin = new EPPDomainContact("sh0813", "admin");
            EPPDomainContact contactBilling = new EPPDomainContact("sh0813", "billing");
            EPPDomainContact contactTech = new EPPDomainContact("sh0813", "tech");
            Vector<EPPDomainContact> contacts = new Vector<EPPDomainContact>();
            contacts.add(contactAdmin);
            contacts.add(contactTech);
            contacts.add(contactBilling);
            theDomainInfoResp.setContacts(contacts);
        } else {
            theResponse = new EPPResponse(respTransId);
            theResponse.setResult(1000);
        }
        EPPRelatedDomainExtInfData infData = new EPPRelatedDomainExtInfData();
        EPPRelatedDomainExtFields fields = new EPPRelatedDomainExtFields();
        fields.setInSync(false);
        fields.addField(new EPPRelatedDomainExtField("clID", false));
        fields.addField(new EPPRelatedDomainExtField("registrant", true));
        fields.addField(new EPPRelatedDomainExtField("ns", false));
        EPPRelatedDomainExtRegistered registered = new EPPRelatedDomainExtRegistered();
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test.tld1"));
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test.tld2"));
        infData.addGroup(new EPPRelatedDomainExtGroup("tld", fields, null, registered));
        fields = new EPPRelatedDomainExtFields();
        fields.setInSync(true);
        fields.addField(new EPPRelatedDomainExtField("clID", true));
        fields.addField(new EPPRelatedDomainExtField("registrant", true));
        fields.addField(new EPPRelatedDomainExtField("ns", true));
        registered = new EPPRelatedDomainExtRegistered();
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test-variant1.tld1"));
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test-variant2.tld1"));
        registered.addRegisteredDomain(new EPPRelatedDomainExtName("xn--test-variant3.tld1"));
        EPPRelatedDomainExtAvailable avail = new EPPRelatedDomainExtAvailable();
        avail.addAvailableDomain(new EPPRelatedDomainExtName("xn--test-variant4.tld1"));
        avail.addAvailableDomain(new EPPRelatedDomainExtName("xn--test-variant5.tld1"));
        avail.addAvailableDomain(new EPPRelatedDomainExtName("xn--test-variant6.tld1"));
        infData.addGroup(new EPPRelatedDomainExtGroup("variant", fields, avail, registered));
        theResponse.addExtension(infData);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    private Date getTodaysUTCDateAtMidnight() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private Date getFiveYearsFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 5);
        return cal.getTime();
    }

    private Date getOneYearFutureDate() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        ((Calendar)cal).add(1, 1);
        return cal.getTime();
    }
}

