/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainRenewCmd;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.fee.v09.EPPFeeCheck;
import com.verisign.epp.codec.fee.v09.EPPFeeCreate;
import com.verisign.epp.codec.fee.v09.EPPFeeRenew;
import com.verisign.epp.codec.fee.v09.EPPFeeTransfer;
import com.verisign.epp.codec.fee.v11.EPPFeeUpdate;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPService;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.serverstub.v09.FeeV09DomainHandler;
import com.verisign.epp.serverstub.v11.FeeV11DomainHandler;
import com.verisign.epp.serverstub.v1_0.FeeV1_0DomainHandler;
import com.verisign.epp.serverstub.v23.FeeV23DomainHandler;
import com.verisign.epp.util.EPPCatFactory;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class FeeDomainHandler
extends DomainHandler {
    private static Logger cat = Logger.getLogger((String)FeeDomainHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    FeeV09DomainHandler v09SubHandler = new FeeV09DomainHandler();
    FeeV11DomainHandler v11SubHandler = new FeeV11DomainHandler();
    FeeV23DomainHandler v23SubHandler = new FeeV23DomainHandler();
    FeeV1_0DomainHandler v1_0SubHandler = new FeeV1_0DomainHandler();

    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPDomainCheckCmd theCommand = (EPPDomainCheckCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainCheck(aEvent, aData);
        if (theCommand.hasExtension(EPPFeeCheck.class)) {
            this.v09SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v11.EPPFeeCheck.class)) {
            this.v11SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v23.EPPFeeCheck.class)) {
            this.v23SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v1_0.EPPFeeCheck.class)) {
            this.v1_0SubHandler.doDomainCheck(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainCheck: fee check = null");
            System.out.println("doDomainCheck: fee check = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        if (theCommand.hasExtension(EPPFeeCreate.class)) {
            this.v09SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v11.EPPFeeCreate.class)) {
            this.v11SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v23.EPPFeeCreate.class)) {
            this.v23SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v1_0.EPPFeeCreate.class)) {
            this.v1_0SubHandler.doDomainCreate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainCreate: fee create = null");
            System.out.println("doDomainCreate: fee create = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        EPPDomainDeleteCmd theCommand = (EPPDomainDeleteCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainDelete(aEvent, aData);
        SessionData theSessionData = (SessionData)aData;
        boolean hasV09ExtService = false;
        boolean hasV11ExtService = false;
        boolean hasV23ExtService = false;
        boolean hasV1_0ExtService = false;
        Enumeration extSvcEnum = theSessionData.getLoginCmd().getExtensionServices().elements();
        while (extSvcEnum.hasMoreElements()) {
            EPPService theExtService = (EPPService)extSvcEnum.nextElement();
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.9")) {
                hasV09ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.11")) {
                hasV11ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.23")) {
                hasV23ExtService = true;
            }
            if (!theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:epp:fee-1.0")) continue;
            hasV1_0ExtService = true;
        }
        if (hasV09ExtService) {
            this.v09SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (hasV11ExtService) {
            this.v11SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (hasV23ExtService) {
            this.v23SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (hasV1_0ExtService) {
            this.v1_0SubHandler.doDomainDelete(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        }
        if (!(hasV09ExtService || hasV11ExtService || hasV23ExtService || hasV1_0ExtService)) {
            cat.info((Object)"doDomainDelete: fee extension not supported by client");
            System.out.println("doDomainDelete: fee extension not supported by client");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainRenew(EPPEvent aEvent, Object aData) {
        EPPDomainRenewCmd theCommand = (EPPDomainRenewCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainRenew(aEvent, aData);
        if (theCommand.hasExtension(EPPFeeRenew.class)) {
            this.v09SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v11.EPPFeeRenew.class)) {
            this.v11SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v23.EPPFeeRenew.class)) {
            this.v23SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v1_0.EPPFeeRenew.class)) {
            this.v1_0SubHandler.doDomainRenew(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainRenew: fee renew = null");
            System.out.println("doDomainRenew: fee renew = null");
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainTransfer(EPPEvent aEvent, Object aData) {
        EPPDomainTransferCmd theCommand = (EPPDomainTransferCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainTransfer(aEvent, aData);
        SessionData theSessionData = (SessionData)aData;
        boolean hasV09ExtService = false;
        boolean hasV11ExtService = false;
        boolean hasV23ExtService = false;
        boolean hasV1_0ExtService = false;
        Enumeration extSvcEnum = theSessionData.getLoginCmd().getExtensionServices().elements();
        while (extSvcEnum.hasMoreElements()) {
            EPPService theExtService = (EPPService)extSvcEnum.nextElement();
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.9")) {
                hasV09ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.11")) {
                hasV11ExtService = true;
            }
            if (theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:fee-0.23")) {
                hasV23ExtService = true;
            }
            if (!theExtService.getNamespaceURI().equals("urn:ietf:params:xml:ns:epp:fee-1.0")) continue;
            hasV1_0ExtService = true;
        }
        if (theCommand.getOp().equals("query")) {
            if (hasV09ExtService) {
                this.v09SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (hasV11ExtService) {
                this.v11SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (hasV23ExtService) {
                this.v23SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (hasV1_0ExtService) {
                this.v1_0SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            }
            if (!(hasV09ExtService || hasV11ExtService || hasV23ExtService || hasV1_0ExtService)) {
                cat.info((Object)"doDomainTransfer: fee extension not supported by client");
                System.out.println("doDomainTransfer: fee extension not supported by client");
            }
        } else if (theCommand.getOp().equals("request")) {
            if (theCommand.hasExtension(EPPFeeTransfer.class)) {
                this.v09SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v11.EPPFeeTransfer.class)) {
                this.v11SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v23.EPPFeeTransfer.class)) {
                this.v23SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v1_0.EPPFeeTransfer.class)) {
                this.v1_0SubHandler.doDomainTransfer(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
            } else {
                cat.info((Object)"doDomainTransfer: fee transfer request = null");
                System.out.println("doDomainTransfer: fee transfer request = null");
            }
        }
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        if (theCommand.hasExtension(com.verisign.epp.codec.fee.v09.EPPFeeUpdate.class)) {
            this.v09SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(EPPFeeUpdate.class)) {
            this.v11SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v23.EPPFeeUpdate.class)) {
            this.v23SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else if (theCommand.hasExtension(com.verisign.epp.codec.fee.v1_0.EPPFeeUpdate.class)) {
            this.v1_0SubHandler.doDomainUpdate(theCommand, (EPPResponse)theEventResponse.getResponse(), aData);
        } else {
            cat.info((Object)"doDomainUpdate: fee update = null");
            System.out.println("doDomainUpdate: fee update = null");
        }
        return theEventResponse;
    }
}

