/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.framework.EPPPollDataRecord;
import com.verisign.epp.framework.EPPPollHandler;
import com.verisign.epp.framework.EPPPollQueueException;

public class DomainPollHandler
implements EPPPollHandler {
    @Override
    public String getKind() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    @Override
    public EPPResponse toResponse(EPPPollDataRecord aRecord) throws EPPPollQueueException {
        if (!aRecord.getKind().equals(this.getKind())) {
            throw new EPPPollQueueException("Handler for kind " + aRecord.getKind() + " does not match");
        }
        EPPResponse theResponse = (EPPResponse)aRecord.getData();
        if (theResponse instanceof EPPDomainTransferResp) {
            theResponse.setMsgQueue(new EPPMsgQueue(Long.valueOf(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Transfer Requested."));
        } else if (theResponse instanceof EPPDomainPendActionMsg) {
            theResponse.setMsgQueue(new EPPMsgQueue(Long.valueOf(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Pending action completed successfully."));
        } else if (theResponse instanceof EPPDomainInfoResp) {
            theResponse.setMsgQueue(new EPPMsgQueue(Long.valueOf(aRecord.getSize()), aRecord.getMsgId(), aRecord.getQDate(), "Registry initiated update of domain."));
        } else {
            throw new EPPPollQueueException("Unable to handle message class <" + theResponse.getClass().getName());
        }
        theResponse.setResult(1301);
        return theResponse;
    }
}

