/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.namestore.util;

import com.verisign.epp.codec.contact.EPPContactCreateCmd;
import com.verisign.epp.codec.contact.EPPContactInfoCmd;
import com.verisign.epp.codec.contact.EPPContactInfoResp;
import com.verisign.epp.codec.contact.EPPContactTransferCmd;
import com.verisign.epp.codec.contact.EPPContactUpdateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegCreateCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoCmd;
import com.verisign.epp.codec.defReg.EPPDefRegInfoResp;
import com.verisign.epp.codec.defReg.EPPDefRegTransferCmd;
import com.verisign.epp.codec.defReg.EPPDefRegUpdateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainTransferCmd;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.loginsec.v01.EPPLoginSec;
import com.verisign.epp.codec.nameWatch.EPPNameWatchCreateCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchInfoResp;
import com.verisign.epp.codec.nameWatch.EPPNameWatchTransferCmd;
import com.verisign.epp.codec.nameWatch.EPPNameWatchUpdateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoInputResult;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtAuthInfo;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtCreate;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtDomain;
import com.verisign.epp.codec.relateddomainext.EPPRelatedDomainExtTransfer;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EPPSendReceiveLogger;
import com.verisign.epp.util.EPPXMLByteArray;
import com.verisign.epp.util.EPPXMLStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;

public class EPPSecureSendReceiveLogger
implements EPPSendReceiveLogger {
    private static final String ATTR_MASKED = "MASKED";
    private static Logger cat = Logger.getLogger((String)EPPSecureSendReceiveLogger.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static Logger packetCat = Logger.getLogger((String)(EPPXMLStream.class.getName() + ".packet"), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    static Pattern xmlTypeErrorPattern = Pattern.compile("^(.*Value ').+(' with .*type ')(pwType|pwAuthInfoType)('.*)$");

    @Override
    public void logSend(byte[] aPacket, EPPMessage aMessage) {
        cat.debug((Object)"logSend(byte[], EPPMessage): enter");
        EPPMessage theMessage = (EPPMessage)this.maskMessage(aMessage);
        if (theMessage == aMessage) {
            this.log("writePacket() : Sending [", aPacket, theMessage);
        } else {
            this.log("writePacket() : Sending [", null, theMessage);
        }
        cat.debug((Object)"logSend(byte[], EPPMessage): exit");
    }

    @Override
    public void logReceive(byte[] aPacket, EPPMessage aMessage) {
        cat.debug((Object)"logReceive(byte[], EPPMessage): enter");
        EPPMessage theMessage = (EPPMessage)this.maskMessage(aMessage);
        if (theMessage == aMessage) {
            this.log("decodePacket() : Received [", aPacket, theMessage);
        } else {
            this.log("decodePacket() : Received [", null, theMessage);
        }
        cat.debug((Object)"logReceive(byte[], EPPMessage): exit");
    }

    @Override
    public String maskString(String aString) {
        cat.debug((Object)"maskString(String): enter");
        if (aString == null) {
            return aString;
        }
        String maskedString = aString;
        Matcher theMatcher = xmlTypeErrorPattern.matcher(aString);
        if (theMatcher.matches()) {
            maskedString = theMatcher.group(1) + ATTR_MASKED + theMatcher.group(2) + theMatcher.group(3) + theMatcher.group(4);
        }
        cat.debug((Object)"maskString(String): exit");
        return maskedString;
    }

    @Override
    public EPPCodecComponent maskMessage(EPPCodecComponent aMessage) {
        EPPCodecComponent theExt;
        cat.debug((Object)"maskMessage(EPPCodecComponent): enter");
        if (aMessage == null) {
            return aMessage;
        }
        EPPMessage theMessage = null;
        if (aMessage instanceof EPPLoginCmd || aMessage instanceof EPPDomainCreateCmd || aMessage instanceof EPPDomainUpdateCmd || aMessage instanceof EPPDomainTransferCmd || aMessage instanceof EPPDomainInfoCmd || aMessage instanceof EPPDomainInfoResp || aMessage instanceof EPPContactCreateCmd || aMessage instanceof EPPContactUpdateCmd || aMessage instanceof EPPContactTransferCmd || aMessage instanceof EPPContactInfoCmd || aMessage instanceof EPPContactInfoResp || aMessage instanceof EPPEmailFwdCreateCmd || aMessage instanceof EPPEmailFwdUpdateCmd || aMessage instanceof EPPEmailFwdTransferCmd || aMessage instanceof EPPEmailFwdInfoCmd || aMessage instanceof EPPEmailFwdInfoResp || aMessage instanceof EPPDefRegCreateCmd || aMessage instanceof EPPDefRegUpdateCmd || aMessage instanceof EPPDefRegTransferCmd || aMessage instanceof EPPDefRegInfoCmd || aMessage instanceof EPPDefRegInfoResp || aMessage instanceof EPPNameWatchCreateCmd || aMessage instanceof EPPNameWatchUpdateCmd || aMessage instanceof EPPNameWatchTransferCmd || aMessage instanceof EPPNameWatchInfoCmd || aMessage instanceof EPPNameWatchInfoResp || aMessage instanceof EPPNameVerificationCreateCmd || aMessage instanceof EPPNameVerificationUpdateCmd || aMessage instanceof EPPNameVerificationInfoCmd || aMessage instanceof EPPNameVerificationInfoResp) {
            try {
                theMessage = (EPPMessage)aMessage.clone();
            }
            catch (CloneNotSupportedException ex) {
                cat.error((Object)("Exception cloning " + aMessage.getClass().getName() + ": " + ex));
                return aMessage;
            }
        } else {
            cat.debug((Object)"maskMessage(EPPCodecComponent): exit - no masking needed");
            return aMessage;
        }
        if (theMessage instanceof EPPLoginCmd) {
            cat.debug((Object)(EPPLoginCmd.class.getName() + " attributes masked"));
            EPPLoginCmd theLoginCmd = (EPPLoginCmd)theMessage;
            theLoginCmd.setPassword(ATTR_MASKED);
            if (theLoginCmd.hasNewPassword()) {
                theLoginCmd.setNewPassword(ATTR_MASKED);
            }
            if (theLoginCmd.hasExtension(EPPLoginSec.class)) {
                cat.debug((Object)"com.verisign.epp.codec.loginsec.v01.EPPLoginSec attributes masked");
                theExt = (EPPLoginSec)theLoginCmd.getExtension(EPPLoginSec.class);
                if (((EPPLoginSec)theExt).hasPassword()) {
                    ((EPPLoginSec)theExt).setPassword(ATTR_MASKED);
                }
                if (((EPPLoginSec)theExt).hasNewPassword()) {
                    ((EPPLoginSec)theExt).setNewPassword(ATTR_MASKED);
                }
            }
        }
        if (theMessage instanceof EPPDomainCreateCmd) {
            cat.debug((Object)(EPPDomainCreateCmd.class.getName() + " attributes masked"));
            EPPDomainCreateCmd theDomainCreateCmd = (EPPDomainCreateCmd)theMessage;
            theDomainCreateCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            if (theDomainCreateCmd.hasExtension(EPPRelatedDomainExtCreate.class)) {
                cat.debug((Object)(EPPRelatedDomainExtCreate.class.getName() + " attributes masked"));
                theExt = (EPPRelatedDomainExtCreate)theDomainCreateCmd.getExtension(EPPRelatedDomainExtCreate.class);
                if (((EPPRelatedDomainExtCreate)theExt).hasDomains()) {
                    for (EPPRelatedDomainExtDomain domain : ((EPPRelatedDomainExtCreate)theExt).getDomains()) {
                        if (!domain.hasAuthInfo()) continue;
                        domain.setAuthInfo(new EPPRelatedDomainExtAuthInfo(ATTR_MASKED));
                    }
                }
            }
        }
        if (theMessage instanceof EPPDomainUpdateCmd) {
            cat.debug((Object)(EPPDomainUpdateCmd.class.getName() + " attributes masked"));
            EPPDomainUpdateCmd theDomainUpdateCmd = (EPPDomainUpdateCmd)theMessage;
            if (theDomainUpdateCmd.getChange() != null && theDomainUpdateCmd.getChange().getAuthInfo() != null) {
                theDomainUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPDomainTransferCmd) {
            cat.debug((Object)(EPPDomainTransferCmd.class.getName() + " attributes masked"));
            EPPDomainTransferCmd theDomainTransferCmd = (EPPDomainTransferCmd)theMessage;
            if (theDomainTransferCmd.getAuthInfo() != null) {
                theDomainTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
            if (theDomainTransferCmd.hasExtension(EPPRelatedDomainExtTransfer.class)) {
                cat.debug((Object)(EPPRelatedDomainExtTransfer.class.getName() + " attributes masked"));
                theExt = (EPPRelatedDomainExtTransfer)theDomainTransferCmd.getExtension(EPPRelatedDomainExtTransfer.class);
                if (((EPPRelatedDomainExtTransfer)theExt).hasDomains()) {
                    for (EPPRelatedDomainExtDomain domain : ((EPPRelatedDomainExtTransfer)theExt).getDomains()) {
                        if (!domain.hasAuthInfo()) continue;
                        domain.setAuthInfo(new EPPRelatedDomainExtAuthInfo(ATTR_MASKED));
                    }
                }
            }
        }
        if (theMessage instanceof EPPDomainInfoCmd) {
            cat.debug((Object)(EPPDomainInfoCmd.class.getName() + " attributes masked"));
            ((EPPDomainInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDomainInfoResp) {
            cat.debug((Object)(EPPDomainInfoResp.class.getName() + " attributes masked"));
            ((EPPDomainInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPContactCreateCmd) {
            cat.debug((Object)(EPPContactCreateCmd.class.getName() + " attributes masked"));
            ((EPPContactCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPContactUpdateCmd) {
            cat.debug((Object)(EPPContactUpdateCmd.class.getName() + " attributes masked"));
            EPPContactUpdateCmd theContactUpdateCmd = (EPPContactUpdateCmd)theMessage;
            if (theContactUpdateCmd.getChange() != null && theContactUpdateCmd.getChange().getAuthInfo() != null) {
                theContactUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPContactTransferCmd) {
            cat.debug((Object)(EPPContactTransferCmd.class.getName() + " attributes masked"));
            EPPContactTransferCmd theContactTransferCmd = (EPPContactTransferCmd)theMessage;
            if (theContactTransferCmd.getAuthInfo() != null) {
                theContactTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPContactInfoCmd) {
            cat.debug((Object)(EPPContactInfoCmd.class.getName() + " attributes masked"));
            ((EPPContactInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPContactInfoResp) {
            cat.debug((Object)(EPPContactInfoResp.class.getName() + " attributes masked"));
            ((EPPContactInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPEmailFwdCreateCmd) {
            cat.debug((Object)(EPPEmailFwdCreateCmd.class.getName() + " attributes masked"));
            ((EPPEmailFwdCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPEmailFwdUpdateCmd) {
            cat.debug((Object)(EPPEmailFwdUpdateCmd.class.getName() + " attributes masked"));
            EPPEmailFwdUpdateCmd theEmailFwdUpdateCmd = (EPPEmailFwdUpdateCmd)theMessage;
            if (theEmailFwdUpdateCmd.getChange() != null && theEmailFwdUpdateCmd.getChange().getAuthInfo() != null) {
                theEmailFwdUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPEmailFwdTransferCmd) {
            cat.debug((Object)(EPPEmailFwdTransferCmd.class.getName() + " attributes masked"));
            EPPEmailFwdTransferCmd theEmailFwdTransferCmd = (EPPEmailFwdTransferCmd)theMessage;
            if (theEmailFwdTransferCmd.getAuthInfo() != null) {
                theEmailFwdTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPEmailFwdInfoCmd) {
            cat.debug((Object)(EPPEmailFwdInfoCmd.class.getName() + " attributes masked"));
            ((EPPEmailFwdInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPEmailFwdInfoResp) {
            cat.debug((Object)(EPPEmailFwdInfoResp.class.getName() + " attributes masked"));
            ((EPPEmailFwdInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDefRegCreateCmd) {
            cat.debug((Object)(EPPDefRegCreateCmd.class.getName() + " attributes masked"));
            ((EPPDefRegCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDefRegUpdateCmd) {
            cat.debug((Object)(EPPDefRegUpdateCmd.class.getName() + " attributes masked"));
            EPPDefRegUpdateCmd theDefRegUpdateCmd = (EPPDefRegUpdateCmd)theMessage;
            if (theDefRegUpdateCmd.getChange() != null && theDefRegUpdateCmd.getChange().getAuthInfo() != null) {
                theDefRegUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPDefRegTransferCmd) {
            cat.debug((Object)(EPPDefRegTransferCmd.class.getName() + " attributes masked"));
            EPPDefRegTransferCmd theDefRegTransferCmd = (EPPDefRegTransferCmd)theMessage;
            if (theDefRegTransferCmd.getAuthInfo() != null) {
                theDefRegTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPDefRegInfoCmd) {
            cat.debug((Object)(EPPDefRegInfoCmd.class.getName() + " attributes masked"));
            ((EPPDefRegInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPDefRegInfoResp) {
            cat.debug((Object)(EPPDefRegInfoResp.class.getName() + " attributes masked"));
            ((EPPDefRegInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameWatchCreateCmd) {
            cat.debug((Object)(EPPNameWatchCreateCmd.class.getName() + " attributes masked"));
            ((EPPNameWatchCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameWatchUpdateCmd) {
            cat.debug((Object)(EPPNameWatchUpdateCmd.class.getName() + " attributes masked"));
            EPPNameWatchUpdateCmd theNameWatchUpdateCmd = (EPPNameWatchUpdateCmd)theMessage;
            if (theNameWatchUpdateCmd.getChange() != null && theNameWatchUpdateCmd.getChange().getAuthInfo() != null) {
                theNameWatchUpdateCmd.getChange().setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPNameWatchTransferCmd) {
            cat.debug((Object)(EPPNameWatchTransferCmd.class.getName() + " attributes masked"));
            EPPNameWatchTransferCmd theNameWatchTransferCmd = (EPPNameWatchTransferCmd)theMessage;
            if (theNameWatchTransferCmd.getAuthInfo() != null) {
                theNameWatchTransferCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPNameWatchInfoCmd) {
            cat.debug((Object)(EPPNameWatchInfoCmd.class.getName() + " attributes masked"));
            ((EPPNameWatchInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameWatchInfoResp) {
            cat.debug((Object)(EPPNameWatchInfoResp.class.getName() + " attributes masked"));
            ((EPPNameWatchInfoResp)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameVerificationCreateCmd) {
            cat.debug((Object)(EPPNameVerificationCreateCmd.class.getName() + " attributes masked"));
            ((EPPNameVerificationCreateCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameVerificationUpdateCmd) {
            cat.debug((Object)(EPPNameVerificationUpdateCmd.class.getName() + " attributes masked"));
            EPPNameVerificationUpdateCmd theNameVerificationUpdateCmd = (EPPNameVerificationUpdateCmd)theMessage;
            if (theNameVerificationUpdateCmd.getAuthInfo() != null) {
                theNameVerificationUpdateCmd.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        if (theMessage instanceof EPPNameVerificationInfoCmd) {
            cat.debug((Object)(EPPNameVerificationInfoCmd.class.getName() + " attributes masked"));
            ((EPPNameVerificationInfoCmd)theMessage).setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
        }
        if (theMessage instanceof EPPNameVerificationInfoResp) {
            cat.debug((Object)(EPPNameVerificationInfoResp.class.getName() + " attributes masked"));
            EPPNameVerificationInfoResp theNameVerificationInfoResp = (EPPNameVerificationInfoResp)theMessage;
            if (theNameVerificationInfoResp.getCreateResult() instanceof EPPNameVerificationInfoInputResult) {
                EPPNameVerificationInfoInputResult result = (EPPNameVerificationInfoInputResult)theNameVerificationInfoResp.getCreateResult();
                result.setAuthInfo(new EPPAuthInfo(ATTR_MASKED));
            }
        }
        cat.debug((Object)"maskMessage(EPPCodecComponent): exit - message masked");
        return theMessage;
    }

    private void log(String logPrefix, byte[] aPacket, EPPMessage aMessage) {
        cat.debug((Object)"log(byte[], EPPMessage): enter");
        if (!packetCat.isDebugEnabled()) {
            return;
        }
        if (aPacket != null) {
            packetCat.debug((Object)(logPrefix + new String(aPacket) + "]"));
        } else if (aMessage != null) {
            try {
                Document theDoc = EPPCodec.getInstance().encode(aMessage);
                EPPXMLByteArray theByteArray = new EPPXMLByteArray("EPP_XML_PARSER_POOL", "EPP_XML_TRANSFORMER_POOL");
                byte[] thePacket = theByteArray.encode(theDoc);
                packetCat.debug((Object)(logPrefix + new String(thePacket) + "]"));
            }
            catch (EPPException ex) {
                cat.error((Object)("log(byte[], EPPMessage); Error encoding message: " + ex));
                return;
            }
        } else {
            cat.error((Object)"log(byte[], EPPMessage); Both aPacket and aMessage are null");
        }
        cat.debug((Object)"log(byte[], EPPMessage): exit");
    }
}

