/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.domain.EPPDomainCheckResp;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.premiumdomain.EPPBaseTst;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainCheck;
import com.verisign.epp.codec.premiumdomain.EPPPremiumDomainReAssignCmd;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPDomain;
import com.verisign.epp.util.TestThread;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPPremiumDomainTst
extends EPPBaseTst {
    private EPPDomain domain = null;

    public EPPPremiumDomainTst(String aName) {
        super(aName);
    }

    public void testPremiumDomain() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.nonPremiumSingleDomainCheckWithNoPremiumExtension(this.domain);
            this.nonPremiumSingleDomainCheckWithFlagTrue(this.domain);
            this.nonPremiumSingleDomainCheckWithFlagFalse(this.domain);
            this.premiumSingleDomainCheckWithFlagTrue(this.domain);
            this.premiumSingleDomainCheckWithFlagFalse(this.domain);
            this.premiumMultipleDomainCheckWithFlagTrue(this.domain);
            this.premiumMultipleDomainCheckWithFlagFalse(this.domain);
            this.premiumDomainUpdate(this.domain);
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void nonPremiumSingleDomainCheckWithNoPremiumExtension(EPPDomain aDomain) {
        this.printStart("Non-Premium Domain Check With No Premium Extension (Check single domain name)");
        String domainName = "non-premiumdomain.tv";
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            aDomain.addDomainName(domainName);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("nonPremiumSingleDomainCheckWithNoPremiumExtension: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Non-Premium Domain Check With No Premium Extension (Check single domain name)");
    }

    public void nonPremiumSingleDomainCheckWithFlagTrue(EPPDomain aDomain) {
        this.printStart("Non-Premium Domain Check With Flag True (Check single domain name)");
        String domainName = "non-premiumdomain.tv";
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            aDomain.addDomainName(domainName);
            EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(true);
            aDomain.addExtension(extension);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("nonPremiumSingleDomainCheckWithFlagTrue: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Non-Premium Domain Check With Flag True (Check single domain name)");
    }

    public void nonPremiumSingleDomainCheckWithFlagFalse(EPPDomain aDomain) {
        this.printStart("Non-Premium Domain Check With Flag False (Check single domain name)");
        String domainName = "non-premiumdomain.tv";
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            aDomain.addDomainName(domainName);
            EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(false);
            aDomain.addExtension(extension);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("nonPremiumSingleDomainCheckWithFlagFalse: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Non-Premium Domain Check With Flag False (Check single domain name)");
    }

    public void premiumSingleDomainCheckWithFlagTrue(EPPDomain aDomain) {
        this.printStart("Premium Domain Check With Flag True (Check single domain name)");
        String domainName = this.makeDomainName();
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            aDomain.addDomainName(domainName);
            EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(true);
            aDomain.addExtension(extension);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("premiumSingleDomainCheckWithFlagTrue: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Premium Domain Check With Flag True (Check single domain name)");
    }

    public void premiumSingleDomainCheckWithFlagFalse(EPPDomain aDomain) {
        this.printStart("Premium Domain Check With Flag False (Check single domain name)");
        String domainName = this.makeDomainName();
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            aDomain.addDomainName(domainName);
            EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(false);
            aDomain.addExtension(extension);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("premiumSingleDomainCheckWithFlagFalse: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Premium Domain Check With Flag False (Check single domain name)");
    }

    public void premiumMultipleDomainCheckWithFlagTrue(EPPDomain aDomain) {
        this.printStart("Premium Domain Check With Flag True (Check multiple domain names)");
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            for (int i = 1; i <= 3; ++i) {
                aDomain.addDomainName(this.makeDomainName());
            }
            EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(true);
            aDomain.addExtension(extension);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("premiumMultipleDomainCheckWithFlagTrue: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Premium Domain Check With Flag True (Check multiple domain names)");
    }

    public void premiumMultipleDomainCheckWithFlagFalse(EPPDomain aDomain) {
        this.printStart("Premium Domain Check With Flag False (Check multiple domain names)");
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            for (int i = 1; i <= 3; ++i) {
                aDomain.addDomainName(this.makeDomainName());
            }
            EPPPremiumDomainCheck extension = new EPPPremiumDomainCheck(false);
            aDomain.addExtension(extension);
            EPPDomainCheckResp response = aDomain.sendCheck();
            System.out.println("premiumMultipleDomainCheckWithFlagFalse: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Premium Domain Check With Flag False (Check multiple domain names)");
    }

    public void premiumDomainUpdate(EPPDomain aDomain) {
        this.printStart("Premium Domain Update");
        String domainName = this.makeDomainName();
        try {
            aDomain.setTransId("ABC-12345-XYZ");
            aDomain.addDomainName(domainName);
            EPPPremiumDomainReAssignCmd extension = new EPPPremiumDomainReAssignCmd("testregistrar");
            aDomain.addExtension(extension);
            EPPResponse response = aDomain.sendUpdate();
            System.out.println("premiumDomainUpdate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("Premium Domain Update");
    }

    protected void setUp() {
        this.createSession();
        this.domain = new EPPDomain(this.getSession());
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPPremiumDomainTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        EPPPremiumDomainTst.initApplication();
        return suite;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPPremiumDomainTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPPremiumDomainTst.suite());
        }
        EPPPremiumDomainTst.endApplication();
    }
}

