/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateFailed;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateSuccess;
import com.verisign.epp.codec.nv.EPPNameVerificationDocument;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.interfaces.EPPApplicationSingle;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPNameVerification;
import com.verisign.epp.interfaces.EPPSession;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.Environment;
import com.verisign.epp.util.TestThread;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public class EPPNameVerificationTst
extends TestCase {
    private static EPPApplicationSingle app = EPPApplicationSingle.getInstance();
    private static String configFileName = "epp.config";
    private static final Logger cat = Logger.getLogger((String)EPPNameVerificationTst.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private EPPNameVerification nameVerification = null;
    private EPPSession session = null;
    private int iteration = 0;
    private Random rd = new Random(System.currentTimeMillis());

    public EPPNameVerificationTst(String name) {
        super(name);
    }

    public void testNameVerification() {
        int numIterations = 1;
        String iterationsStr = System.getProperty("iterations");
        if (iterationsStr != null) {
            numIterations = Integer.parseInt(iterationsStr);
        }
        this.iteration = 0;
        while (numIterations == 0 || this.iteration < numIterations) {
            this.printStart("Test Suite");
            this.nvCheck();
            this.nvInfo();
            this.nvCreate();
            this.nvUpdate();
            this.printEnd("Test Suite");
            ++this.iteration;
        }
    }

    public void nvCheck() {
        this.printStart("nvCheck");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCheck: Check command with three domain labels");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.addLabel("example1");
            this.nameVerification.addLabel("example2");
            this.nameVerification.addLabel("example3");
            EPPNameVerificationCheckResp response = this.nameVerification.sendCheck();
            System.out.println("nvCheck: Check Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nvCheck");
    }

    public void nvInfo() {
        EPPNameVerificationInfoResp response;
        this.printStart("nvInfo");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvInfo: Info command for signed code");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setInfoType(EPPNameVerificationInfoCmd.Type.SIGNED_CODE);
            this.nameVerification.setCode("1-abc123");
            response = this.nameVerification.sendInfo();
            System.out.println("nvInfo: Signed Code Type Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvInfo: Info command for input data (DNV)");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setInfoType(EPPNameVerificationInfoCmd.Type.INPUT);
            this.nameVerification.setCode("1-abc123");
            response = this.nameVerification.sendInfo();
            System.out.println("nvInfo: DNV Input Type Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvInfo: Info command for input data (RNV)");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setInfoType(EPPNameVerificationInfoCmd.Type.INPUT);
            this.nameVerification.setCode("abc-rnv123");
            response = this.nameVerification.sendInfo();
            System.out.println("nvInfo: RNV Input Type Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nvInfo");
    }

    public void nvCreate() {
        EPPNameVerificationCreateResp response;
        this.printStart("nvCreate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Create Domain Name Verification (DNV) object");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setDnv(new EPPDomainNameVerification("example"));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            System.out.println("nvCreate: DNV Create Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Create pending Domain Name Verification (DNV) object");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setDnv(new EPPDomainNameVerification("PENDING"));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            System.out.println("nvCreate: DNV Create Response = [" + response + "]\n\n");
            Assert.assertTrue((response.getResult().getCode() == 1001 ? 1 : 0) != 0);
            this.session.setPollOp("req");
            EPPResponse pollResponse = this.session.sendPoll();
            System.out.println("nvCreate: 1 - Poll message = [" + pollResponse + "]\n\n");
            if (pollResponse.getMsgQueueCount() > 0L) {
                this.session.setPollOp("ack");
                this.session.setMsgID(pollResponse.getMsgQueue().getId());
                pollResponse = this.session.sendPoll();
                System.out.println("nvCreate: 2 - Poll message = [" + pollResponse + "]\n\n");
            }
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Failed Create Domain Name Verification (DNV) object");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setDnv(new EPPDomainNameVerification("FAILED"));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            System.out.println("nvCreate: DNV Failed Create Response = [" + response + "]\n\n");
            Assert.assertTrue((response.getResult().getCode() == 1000 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)(response.getCreateResult() instanceof EPPNameVerificationCreateFailed));
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Create reserved Domain Name Verification (DNV) object");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setDnv(new EPPDomainNameVerification("example", "1-abc123"));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            System.out.println("nvCreate: DNV Create Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Create Domain Name Verification (DNV) object that returns invalid code type");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setDnv(new EPPDomainNameVerification("invalid-type"));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            Assert.assertTrue((boolean)(response.getCreateResult() instanceof EPPNameVerificationCreateSuccess));
            Assert.assertEquals((String)"invalid-type", (String)((EPPNameVerificationCreateSuccess)response.getCreateResult()).getSignedCode().getCodeType());
            System.out.println("nvCreate: DNV \"invalid-type\" Create Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Create Real Name Verification (RNV) object for person");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POE, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            System.out.println("nvCreate: RNV Create Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvCreate: Create Real Name Verification (RNV) object for org");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setRnv(new EPPRealNameVerification(EPPRealNameVerification.Role.ORG, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POE, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")));
            this.nameVerification.setAuthInfo("2fooBAR");
            response = this.nameVerification.sendCreate();
            System.out.println("nvCreate: Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nvCreate");
    }

    public void nvUpdate() {
        this.printStart("nvUpdate");
        try {
            System.out.println("\n----------------------------------------------------------------");
            System.out.println("nvUpdate: Update command with authInfo");
            this.nameVerification.setTransId("ABC-12345");
            this.nameVerification.setCode("1-abc123");
            this.nameVerification.setAuthInfo("2BARfoo");
            EPPResponse response = this.nameVerification.sendUpdate();
            System.out.println("nvUpdate: Update Response = [" + response + "]\n\n");
        }
        catch (EPPCommandException e) {
            this.handleException(e);
        }
        this.printEnd("nvUpdate");
    }

    private void initSession() {
        this.printStart("initSession");
        this.session.setClientID(Environment.getProperty("EPP.Test.clientId", "ClientX"));
        this.session.setPassword(Environment.getProperty("EPP.Test.password", "foo-BAR2"));
        this.session.setTransId("ABC-12345-XYZ");
        this.session.setVersion("1.0");
        this.session.setLang("en");
        try {
            this.session.initSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("initSession");
    }

    private void endSession() {
        this.printStart("endSession");
        this.session.setTransId("ABC-12345-XYZ");
        try {
            this.session.endSession();
        }
        catch (EPPCommandException e) {
            EPPResponse response = this.session.getResponse();
            if (response != null && !response.isSuccess()) {
                Assert.fail((String)("Server Error : " + response));
            }
            e.printStackTrace();
            Assert.fail((String)("initSession Error : " + e));
        }
        this.printEnd("endSession");
    }

    protected void setUp() {
        try {
            String theSessionClassName = System.getProperty("EPP.SessionClass");
            if (theSessionClassName != null) {
                try {
                    Class<?> theSessionClass = Class.forName(theSessionClassName);
                    if (!EPPSession.class.isAssignableFrom(theSessionClass)) {
                        Assert.fail((String)(theSessionClassName + " is not a subclass of EPPSession"));
                    }
                    this.session = (EPPSession)theSessionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception ex) {
                    Assert.fail((String)("Exception instantiating EPP.SessionClass value " + theSessionClassName + ": " + ex));
                }
            } else {
                this.session = new EPPSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the session: " + e));
        }
        this.initSession();
        this.nameVerification = new EPPNameVerification(this.session);
    }

    protected void tearDown() {
        this.endSession();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(EPPNameVerificationTst.class);
        String theConfigFileName = System.getProperty("EPP.ConfigFile");
        if (theConfigFileName != null) {
            configFileName = theConfigFileName;
        }
        try {
            app.initialize(configFileName);
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error initializing the EPP Application: " + e));
        }
        return suite;
    }

    public void handleException(Exception aException) {
        EPPResponse response = this.session.getResponse();
        aException.printStackTrace();
        if (response != null && !response.isSuccess()) {
            Assert.fail((String)("Server Error : " + response));
        } else {
            Assert.fail((String)("General Error : " + aException));
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configFileName = args[0];
        }
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPSessionTst Thread " + i, EPPNameVerificationTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPNameVerificationTst.suite());
        }
        try {
            app.endApplication();
        }
        catch (EPPCommandException e) {
            e.printStackTrace();
            Assert.fail((String)("Error ending the EPP Application: " + e));
        }
    }

    private void printStart(String aTest) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " Start"));
        }
        System.out.println("Start of " + aTest);
        System.out.println("****************************************************************\n");
    }

    private void printEnd(String aTest) {
        System.out.println("****************************************************************");
        if (Thread.currentThread() instanceof TestThread) {
            System.out.print(Thread.currentThread().getName() + ", iteration " + this.iteration + ": ");
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aTest + " End"));
        }
        System.out.println("End of " + aTest);
        System.out.println("\n");
    }

    private void printMsg(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.out.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.info((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.out.println(aMsg);
            cat.info((Object)aMsg);
        }
    }

    private void printError(String aMsg) {
        if (Thread.currentThread() instanceof TestThread) {
            System.err.println(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg);
            cat.error((Object)(Thread.currentThread().getName() + ", iteration " + this.iteration + ": " + aMsg));
        } else {
            System.err.println(aMsg);
            cat.error((Object)aMsg);
        }
    }
}

