/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdAddRemove;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCheckResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdCreateResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdDeleteCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdInfoResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdPeriod;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdRenewResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdStatus;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferCmd;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdTransferResp;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdUpdateCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Date;
import java.util.Vector;

public class EPPEmailFwd {
    public static final int CONTACT = 1;
    public static final int STATUS = 2;
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int CHANGE = 3;
    public static final String STATUS_OK = "ok";
    public static final String STATUS_SERVER_HOLD = "serverHold";
    public static final String STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String STATUS_PENDING_CREATE = "pendingCreate";
    public static final String STATUS_PENDING_DELETE = "pendingDelete";
    public static final String STATUS_PENDING_RENEW = "pendingRenew";
    public static final String STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String STATUS_PENDING_UPDATE = "pendingUpdate";
    public static final String STATUS_CLIENT_HOLD = "clientHold";
    public static final String STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    public static final String TRANSFER_APPROVE = "approve";
    public static final String TRANSFER_CANCEL = "cancel";
    public static final String TRANSFER_QUERY = "query";
    public static final String TRANSFER_REJECT = "reject";
    public static final String TRANSFER_REQUEST = "request";
    public static final String CONTACT_ADMINISTRATIVE = "admin";
    public static final String CONTACT_BILLING = "billing";
    public static final String CONTACT_TECHNICAL = "tech";
    public static final String PERIOD_MONTH = "m";
    public static final String PERIOD_YEAR = "y";
    private Vector myEmailFwdList = new Vector();
    private String myForwardTo = null;
    private Vector myContactList = new Vector();
    private Vector myUpdateAttribs = new Vector();
    private EPPSession mySession = null;
    private String myTransId = null;
    private Date myExpirationDate;
    private String myTransferOpCode;
    private int myPeriodLength = 1;
    private String myPeriodUnit;
    private String myAuthString;
    private String authRoid;
    private Vector extensions = null;
    private String myRegistrant = null;

    public EPPEmailFwd(EPPSession newSession) {
        this.mySession = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public void setExtension(EPPCodecComponent aExtension) {
        this.addExtension(aExtension);
    }

    public void setExtensions(Vector aExtensions) {
        this.extensions = aExtensions;
    }

    public Vector getExtensions() {
        return this.extensions;
    }

    public void addEmailFwdName(String newEmailFwd) {
        this.myEmailFwdList.addElement(newEmailFwd);
    }

    public void addContact(String newName, String newType) {
        this.myContactList.addElement(new EPPEmailFwdContact(newName, newType));
    }

    public void setExpirationDate(Date newExpirationDate) {
        this.myExpirationDate = newExpirationDate;
    }

    public Date getExpirationDate() {
        return this.myExpirationDate;
    }

    public void setTransferOpCode(String newTransferOpCode) {
        this.myTransferOpCode = newTransferOpCode;
    }

    public void setTransId(String newTransId) {
        this.myTransId = newTransId;
    }

    public void setAuthString(String newAuthString) {
        this.myAuthString = newAuthString;
    }

    public String getAuthString() {
        return this.myAuthString;
    }

    public String getAuthRoid() {
        return this.authRoid;
    }

    public void setAuthRoid(String aAuthRoid) {
        this.authRoid = aAuthRoid;
    }

    public void setForwardTo(String newForwardTo) {
        this.myForwardTo = newForwardTo;
    }

    public String getForwardTo() {
        return this.myForwardTo;
    }

    public String getRegistrant() {
        return this.myRegistrant;
    }

    public void setRegistrant(String aRegistrant) {
        this.myRegistrant = aRegistrant;
    }

    public EPPEmailFwdCreateResp sendCreate() throws EPPCommandException {
        if (this.myEmailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendCreate()");
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
            if (this.myContactList.size() == 0) {
                this.myContactList = null;
            }
        } else {
            this.myContactList = null;
        }
        EPPEmailFwdPeriod thePeriod = null;
        if (this.myPeriodLength >= 0) {
            thePeriod = this.myPeriodUnit != null ? new EPPEmailFwdPeriod(this.myPeriodUnit, this.myPeriodLength) : new EPPEmailFwdPeriod(this.myPeriodLength);
        }
        EPPEmailFwdCreateCmd theCommand = new EPPEmailFwdCreateCmd(this.myTransId, (String)this.myEmailFwdList.firstElement(), this.myForwardTo, this.myContactList, thePeriod, new EPPAuthInfo(this.myAuthString));
        if (this.myRegistrant != null) {
            theCommand.setRegistrant(this.myRegistrant);
        }
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdCreateResp)this.mySession.processDocument(theCommand, EPPEmailFwdCreateResp.class);
    }

    public EPPResponse sendUpdate() throws EPPCommandException {
        if (this.myEmailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendUpdate()");
        }
        Vector contactUpdate = null;
        Vector statusUpdate = null;
        contactUpdate = this.getUpdateAttribCnt(1, 1) == 0 ? null : this.getUpdateAttribVector(1, 1);
        statusUpdate = this.getUpdateAttribCnt(2, 1) == 0 ? null : this.getUpdateAttribVector(2, 1);
        EPPEmailFwdAddRemove addItems = null;
        if (contactUpdate != null || statusUpdate != null) {
            addItems = new EPPEmailFwdAddRemove(contactUpdate, statusUpdate);
        }
        contactUpdate = this.getUpdateAttribCnt(1, 2) == 0 ? null : this.getUpdateAttribVector(1, 2);
        statusUpdate = this.getUpdateAttribCnt(2, 2) == 0 ? null : this.getUpdateAttribVector(2, 2);
        EPPEmailFwdAddRemove removeItems = null;
        if (contactUpdate != null || statusUpdate != null) {
            removeItems = new EPPEmailFwdAddRemove(contactUpdate, statusUpdate);
        }
        EPPEmailFwdAddRemove changeItems = null;
        if (this.myRegistrant != null || this.myForwardTo != null || this.myAuthString != null) {
            changeItems = new EPPEmailFwdAddRemove();
            if (this.myRegistrant != null) {
                changeItems.setRegistrant(this.myRegistrant);
            }
            if (this.myForwardTo != null) {
                changeItems.setForwardTo(this.myForwardTo);
            }
            if (this.myAuthString != null) {
                changeItems.setAuthInfo(new EPPAuthInfo(this.myAuthString));
            }
        }
        EPPEmailFwdUpdateCmd theCommand = new EPPEmailFwdUpdateCmd(this.myTransId, (String)this.myEmailFwdList.firstElement(), addItems, removeItems, changeItems);
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return this.mySession.processDocument(theCommand, EPPResponse.class);
    }

    public EPPEmailFwdTransferResp sendTransfer() throws EPPCommandException {
        if (this.myEmailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendTransfer()");
        }
        if (this.myTransferOpCode == null) {
            throw new EPPCommandException("Transfer Operation Code is required.");
        }
        EPPEmailFwdTransferCmd theCommand = new EPPEmailFwdTransferCmd(this.myTransId, this.myTransferOpCode, (String)this.myEmailFwdList.firstElement());
        if (this.myAuthString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.myAuthString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            theCommand.setAuthInfo(theAuthInfo);
        }
        if (this.myTransferOpCode.equals(TRANSFER_REQUEST)) {
            if (this.myAuthString == null) {
                throw new EPPCommandException("Auth Info must be set on a Transfer Request");
            }
            EPPEmailFwdPeriod thePeriod = null;
            thePeriod = this.myPeriodLength < 0 ? null : (this.myPeriodUnit == null ? new EPPEmailFwdPeriod(this.myPeriodLength) : new EPPEmailFwdPeriod(this.myPeriodUnit, this.myPeriodLength));
            theCommand.setPeriod(thePeriod);
        }
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdTransferResp)this.mySession.processDocument(theCommand, EPPEmailFwdTransferResp.class);
    }

    public EPPEmailFwdRenewResp sendRenew() throws EPPCommandException {
        if (this.myEmailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendCreate()");
        }
        EPPEmailFwdPeriod thePeriod = null;
        if (this.myPeriodLength >= 0) {
            thePeriod = this.myPeriodUnit != null ? new EPPEmailFwdPeriod(this.myPeriodUnit, this.myPeriodLength) : new EPPEmailFwdPeriod(this.myPeriodLength);
        }
        EPPEmailFwdRenewCmd theCommand = new EPPEmailFwdRenewCmd(this.myTransId, (String)this.myEmailFwdList.firstElement(), this.myExpirationDate, thePeriod);
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdRenewResp)this.mySession.processDocument(theCommand, EPPEmailFwdRenewResp.class);
    }

    public EPPEmailFwdInfoResp sendInfo() throws EPPCommandException {
        if (this.myEmailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendInfo()");
        }
        EPPEmailFwdInfoCmd theCommand = new EPPEmailFwdInfoCmd(this.myTransId, (String)this.myEmailFwdList.firstElement());
        if (this.myAuthString != null) {
            EPPAuthInfo theAuthInfo = new EPPAuthInfo(this.myAuthString);
            if (this.authRoid != null) {
                theAuthInfo.setRoid(this.authRoid);
            }
            theCommand.setAuthInfo(theAuthInfo);
        }
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdInfoResp)this.mySession.processDocument(theCommand, EPPEmailFwdInfoResp.class);
    }

    public EPPEmailFwdCheckResp sendCheck() throws EPPCommandException {
        EPPEmailFwdCheckCmd theCommand = new EPPEmailFwdCheckCmd(this.myTransId, this.myEmailFwdList);
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return (EPPEmailFwdCheckResp)this.mySession.processDocument(theCommand, EPPEmailFwdCheckResp.class);
    }

    public EPPResponse sendDelete() throws EPPCommandException {
        if (this.myEmailFwdList.size() != 1) {
            throw new EPPCommandException("One Email Forward Name is required for sendDelete()");
        }
        EPPEmailFwdDeleteCmd theCommand = new EPPEmailFwdDeleteCmd(this.myTransId, (String)this.myEmailFwdList.firstElement());
        theCommand.setExtensions(this.extensions);
        this.resetEmailFwd();
        return this.mySession.processDocument(theCommand, EPPResponse.class);
    }

    private void resetEmailFwd() {
        this.myEmailFwdList = new Vector();
        this.myContactList = new Vector();
        this.myUpdateAttribs = new Vector();
        this.myForwardTo = null;
        this.myTransId = null;
        this.myExpirationDate = null;
        this.myTransferOpCode = null;
        this.myPeriodLength = 1;
        this.myPeriodUnit = null;
        this.myAuthString = null;
        this.authRoid = null;
        this.extensions = null;
        this.myRegistrant = null;
    }

    public void setUpdateAttrib(int newType, EPPEmailFwdStatus newName, int newOp) throws EPPCommandException {
        if (newType != 2) {
            throw new EPPCommandException("setUpdateAttrib(int, EPPEmailFwdStatus, int): " + newType + " is an invalid type");
        }
        if (newOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, EPPEmailFwdStatus, int): CHANGE is an invalid operation");
        }
        this.myUpdateAttribs.addElement(new UpdateAttrib(newType, newName, newOp));
    }

    public void setUpdateAttrib(int newType, String newVal, String newValType, int newOp) throws EPPCommandException {
        if (newType != 1) {
            throw new EPPCommandException("setUpdateAttrib(int, String, String, int): " + newType + " is an invalid type");
        }
        if (newOp == 3) {
            throw new EPPCommandException("setUpdateAttrib(int, String, String, int): CHANGE is an invalid operation");
        }
        this.myUpdateAttribs.addElement(new UpdateAttrib(newType, new EPPEmailFwdContact(newVal, newValType), newOp));
    }

    public EPPResponse getResponse() {
        return this.mySession.getResponse();
    }

    public int getPeriodLength() {
        return this.myPeriodLength;
    }

    public void setPeriodLength(int newPeriodLength) {
        this.myPeriodLength = newPeriodLength;
    }

    public String getPeriodUnit() {
        return this.myPeriodUnit;
    }

    public void setPeriodUnit(String newPeriodUnit) {
        this.myPeriodUnit = newPeriodUnit;
    }

    private int getUpdateAttribCnt(int newType, int newOp) {
        int cnt = 0;
        for (int i = 0; i < this.myUpdateAttribs.size(); ++i) {
            UpdateAttrib currAttrib = (UpdateAttrib)this.myUpdateAttribs.elementAt(i);
            if (!currAttrib.getType(newType, newOp)) continue;
            ++cnt;
        }
        return cnt;
    }

    private Vector getUpdateAttribVector(int newType, int newOp) {
        int cnt = this.getUpdateAttribCnt(newType, newOp);
        if (cnt == 0) {
            return null;
        }
        Vector<Object> theAttribs = new Vector<Object>(cnt);
        for (int i = 0; i < this.myUpdateAttribs.size(); ++i) {
            UpdateAttrib currAttr = (UpdateAttrib)this.myUpdateAttribs.elementAt(i);
            if (!currAttr.getType(newType, newOp)) continue;
            theAttribs.addElement(currAttr.getVal());
        }
        return theAttribs;
    }

    private static class UpdateAttrib {
        private int myType = 0;
        private Object myVal = null;
        private int myOp = 0;

        public UpdateAttrib(int newType, Object newVal, int newOp) throws EPPCommandException {
            if (newType != 1 && newType != 2) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Type of " + newType);
            }
            if (newOp != 1 && newOp != 2 && newOp != 3) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Operation of " + newOp);
            }
            if (newVal == null) {
                throw new EPPCommandException("UpdateAttrib.UpdateAttrib() : Invalid Value (null)");
            }
            this.myType = newType;
            this.myVal = newVal;
            this.myOp = newOp;
        }

        public boolean getType(int newType, int newOp) {
            return newType == this.myType && newOp == this.myOp;
        }

        public Object getVal() {
            return this.myVal;
        }
    }
}

