/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework.validate.v02;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.validate.v02.EPPValidateCheckCmd;
import com.verisign.epp.codec.validate.v02.EPPValidateMapFactory;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPValidateHandler
implements EPPEventHandler {
    private static final Logger cat = Logger.getLogger((String)EPPValidateHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPValidateHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPValidateMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Validate Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:validate-0.2";
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        EPPEventResponse response = null;
        if (message instanceof EPPValidateCheckCmd) {
            response = this.doValidateCheck(aEvent, aData);
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected abstract EPPEventResponse doValidateCheck(EPPEvent var1, Object var2);

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }
}

