/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.framework;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.org.EPPOrgCheckCmd;
import com.verisign.epp.codec.org.EPPOrgCreateCmd;
import com.verisign.epp.codec.org.EPPOrgDeleteCmd;
import com.verisign.epp.codec.org.EPPOrgInfoCmd;
import com.verisign.epp.codec.org.EPPOrgMapFactory;
import com.verisign.epp.codec.org.EPPOrgUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventHandler;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;

public abstract class EPPOrgHandler
implements EPPEventHandler {
    private static final Logger cat = Logger.getLogger((String)EPPOrgHandler.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());

    public EPPOrgHandler() {
        try {
            EPPFactory.getInstance().addMapFactory(EPPOrgMapFactory.class.getName());
        }
        catch (EPPCodecException e) {
            cat.error((Object)"Couldn't load the Map Factory associated with the Org Mapping", (Throwable)e);
            System.exit(1);
        }
    }

    @Override
    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp:org-1.0";
    }

    @Override
    public EPPEventResponse handleEvent(EPPEvent aEvent, Object aData) throws EPPEventException {
        try {
            this.preHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        EPPMessage message = aEvent.getMessage();
        EPPEventResponse response = null;
        if (message instanceof EPPOrgCheckCmd) {
            response = this.doOrgCheck(aEvent, aData);
        } else if (message instanceof EPPOrgInfoCmd) {
            response = this.doOrgInfo(aEvent, aData);
        } else if (message instanceof EPPOrgCreateCmd) {
            response = this.doOrgCreate(aEvent, aData);
        } else if (message instanceof EPPOrgDeleteCmd) {
            response = this.doOrgDelete(aEvent, aData);
        } else if (message instanceof EPPOrgUpdateCmd) {
            response = this.doOrgUpdate(aEvent, aData);
        }
        try {
            this.postHandleEvent(aEvent, aData);
        }
        catch (EPPHandleEventException e) {
            return new EPPEventResponse(e.getResponse());
        }
        return response;
    }

    protected abstract EPPEventResponse doOrgCheck(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doOrgInfo(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doOrgCreate(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doOrgDelete(EPPEvent var1, Object var2);

    protected abstract EPPEventResponse doOrgUpdate(EPPEvent var1, Object var2);

    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }
}

